/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util.image;

import com.arm.mgd.core.util.image.PixelReader;

public class PixelScaler {
    private static final IPixelScaler BYTECAST_CHANNEL_SCALER = new IPixelScaler(){

        @Override
        public byte[] scalePixel(long[] pixelData) {
            return new byte[]{(byte)pixelData[0], (byte)pixelData[1], (byte)pixelData[2], (byte)pixelData[3]};
        }
    };

    static IPixelScaler getPixelScaler(RangeMode rangeMode, PixelReader.IPixelReader reader, long[] channelMin, long[] channelMax) {
        switch (rangeMode) {
            case PER_CHANNEL_DYNAMIC_RANGE: {
                PerChannelScaler.Mode scalerMode = reader.hasAlpha() ? PerChannelScaler.Mode.THROW_AWAY_CHANNEL_IF_ALPHA_IS_ZERO : PerChannelScaler.Mode.RETAIN_ALL_CHANNELS;
                return new PerChannelScaler(channelMin, channelMax, scalerMode);
            }
            case PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS: {
                return new PerChannelScaler(channelMin, channelMax, PerChannelScaler.Mode.RETAIN_ALL_CHANNELS);
            }
            case PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS_DONT_SCALE_ALPHA: {
                return new PerChannelScaler(new long[]{channelMin[0], channelMin[1], channelMin[2], reader.getAMin()}, new long[]{channelMax[0], channelMax[1], channelMax[2], reader.getAMax()}, PerChannelScaler.Mode.RETAIN_ALL_CHANNELS);
            }
        }
        if (reader.isByteRanged()) {
            return BYTECAST_CHANNEL_SCALER;
        }
        return new PerChannelScaler(new long[]{reader.getRMin(), reader.getGMin(), reader.getBMin(), reader.getAMin()}, new long[]{reader.getRMax(), reader.getGMax(), reader.getBMax(), reader.getAMax()}, PerChannelScaler.Mode.RETAIN_ALL_CHANNELS);
    }

    static interface IPixelScaler {
        public byte[] scalePixel(long[] var1);
    }

    private static class PerChannelScaler
    implements IPixelScaler {
        private final long[] channelMin;
        private final double[] channelScale;
        private final boolean[] useZeroRangeValue;
        private final byte[] zeroRangeValue;
        private final boolean throwAwayColoursIfAlphaIsZero;

        public PerChannelScaler(long[] channelMin, long[] channelMax, Mode scalerMode) {
            this.channelMin = channelMin;
            this.throwAwayColoursIfAlphaIsZero = scalerMode == Mode.THROW_AWAY_CHANNEL_IF_ALPHA_IS_ZERO;
            this.channelScale = new double[4];
            this.useZeroRangeValue = new boolean[4];
            this.zeroRangeValue = new byte[4];
            int i = 0;
            while (i < 4) {
                long channelRange = channelMax[i] - channelMin[i];
                if (channelRange == 0L) {
                    this.channelScale[i] = 1.0;
                    this.useZeroRangeValue[i] = true;
                } else {
                    this.channelScale[i] = 255.0 / (double)channelRange;
                    this.useZeroRangeValue[i] = false;
                }
                this.zeroRangeValue[i] = (byte)(channelMin[i] != 0L ? 255 : 0);
                ++i;
            }
        }

        @Override
        public byte[] scalePixel(long[] pixelData) {
            int r0 = (int)((double)(pixelData[0] - this.channelMin[0]) * this.channelScale[0]);
            int g0 = (int)((double)(pixelData[1] - this.channelMin[1]) * this.channelScale[1]);
            int b0 = (int)((double)(pixelData[2] - this.channelMin[2]) * this.channelScale[2]);
            int a0 = (int)((double)(pixelData[3] - this.channelMin[3]) * this.channelScale[3]);
            int r1 = this.useZeroRangeValue[0] ? this.zeroRangeValue[0] : r0;
            int g1 = this.useZeroRangeValue[1] ? this.zeroRangeValue[1] : g0;
            int b1 = this.useZeroRangeValue[2] ? this.zeroRangeValue[2] : b0;
            int a1 = this.useZeroRangeValue[3] ? this.zeroRangeValue[3] : a0;
            int rMult = pixelData[0] == 0L ? 0 : 1;
            int gMult = pixelData[1] == 0L ? 0 : 1;
            int bMult = pixelData[2] == 0L ? 0 : 1;
            int throwAwayColours = pixelData[3] == 0L && this.throwAwayColoursIfAlphaIsZero ? 0 : 1;
            byte r = (byte)(r1 * rMult * throwAwayColours);
            byte g = (byte)(g1 * gMult * throwAwayColours);
            byte b = (byte)(b1 * bMult * throwAwayColours);
            byte a = (byte)a1;
            return new byte[]{r, g, b, a};
        }

        private static enum Mode {
            RETAIN_ALL_CHANNELS,
            THROW_AWAY_CHANNEL_IF_ALPHA_IS_ZERO;

        }
    }

    public static enum RangeMode {
        NO_DYNAMIC_RANGE,
        PER_CHANNEL_DYNAMIC_RANGE,
        PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS,
        PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS_DONT_SCALE_ALPHA;

    }
}

