/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util.image;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;

public class PixelReader {
    static final @NonNull IPixelReader DEPTH_COMPONENT16 = new IPixelReader(){

        @Override
        public long getRMax() {
            return 32767L;
        }

        @Override
        public long getBMax() {
            return 32767L;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            int word = PixelReader.makeShort(inputData, offset);
            float depthValue = (float)word / 65535.0f * 2.0f - 1.0f;
            int channelValue = (int)(Math.abs(depthValue) * 32767.0f);
            long[] lArray = new long[4];
            lArray[0] = depthValue > 0.0f ? channelValue : 0;
            lArray[2] = depthValue < 0.0f ? channelValue : 0;
            return lArray;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public int getPixelSize() {
            return 2;
        }
    };
    static final @NonNull IPixelReader R8 = new IPixelReader(){

        @Override
        public long getRMax() {
            return 255L;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long[] lArray = new long[4];
            lArray[0] = inputData.get(offset) & 0xFF;
            lArray[3] = 255L;
            return lArray;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return true;
        }

        @Override
        public int getPixelSize() {
            return 1;
        }
    };
    static final @NonNull IPixelReader R32_UI = new IPixelReader(){

        @Override
        public long getRMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long r = PixelReader.makeUnsignedInt(inputData, offset) & 0xFFFFFFFFFFFFFFFFL;
            long[] lArray = new long[4];
            lArray[0] = r;
            return lArray;
        }

        @Override
        public int getPixelSize() {
            return 4;
        }
    };
    static final @NonNull IPixelReader A2R10G10B10_UI = new IPixelReader(){

        @Override
        public long getRMax() {
            return 1023L;
        }

        @Override
        public long getGMax() {
            return 1023L;
        }

        @Override
        public long getBMax() {
            return 1023L;
        }

        @Override
        public long getAMax() {
            return 3L;
        }

        @Override
        public boolean hasAlpha() {
            return true;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long word = PixelReader.makeUnsignedInt(inputData, offset) & 0xFFFFFFFFFFFFFFFFL;
            long a = word >> 30 & 3L;
            long r = word >> 20 & 0x3FFL;
            long g = word >> 10 & 0x3FFL;
            long b = word >> 0 & 0x3FFL;
            return new long[]{r, g, b, a};
        }

        @Override
        public int getPixelSize() {
            return 4;
        }
    };
    static final @NonNull IPixelReader A2B10G10R10_UI = new IPixelReader(){

        @Override
        public long getRMax() {
            return 1023L;
        }

        @Override
        public long getGMax() {
            return 1023L;
        }

        @Override
        public long getBMax() {
            return 1023L;
        }

        @Override
        public long getAMax() {
            return 3L;
        }

        @Override
        public boolean hasAlpha() {
            return true;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long word = PixelReader.makeInt(inputData, offset) & 0xFFFFFFFF;
            long r = word & 0x3FFL;
            long g = word >> 10 & 0x3FFL;
            long b = word >> 20 & 0x3FFL;
            long a = word >> 30 & 3L;
            return new long[]{r, g, b, a};
        }

        @Override
        public int getPixelSize() {
            return 4;
        }
    };
    static final @NonNull IPixelReader R5G6B5 = new IPixelReader(){

        @Override
        public long getRMax() {
            return 31L;
        }

        @Override
        public long getGMax() {
            return 63L;
        }

        @Override
        public long getBMax() {
            return 31L;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            int word = inputData.get(offset + 0) & 0xFF | (inputData.get(offset + 1) & 0xFF) << 8;
            long[] lArray = new long[4];
            lArray[0] = word >> 11 & 0x1F;
            lArray[1] = word >> 5 & 0x3F;
            lArray[2] = word & 0x1F;
            return lArray;
        }

        @Override
        public int getPixelSize() {
            return 2;
        }
    };
    static final @NonNull IPixelReader R8G8B8 = new IPixelReader(){

        @Override
        public long getRMax() {
            return 255L;
        }

        @Override
        public long getGMax() {
            return 255L;
        }

        @Override
        public long getBMax() {
            return 255L;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return true;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long[] lArray = new long[4];
            lArray[0] = inputData.get(offset) & 0xFF;
            lArray[1] = inputData.get(offset + 1) & 0xFF;
            lArray[2] = inputData.get(offset + 2) & 0xFF;
            return lArray;
        }

        @Override
        public int getPixelSize() {
            return 3;
        }
    };
    static final @NonNull IPixelReader R16G16B16A16_UI = new IPixelReader(){

        @Override
        public long getRMax() {
            return 65535L;
        }

        @Override
        public long getGMax() {
            return 65535L;
        }

        @Override
        public long getBMax() {
            return 65535L;
        }

        @Override
        public long getAMax() {
            return 65535L;
        }

        @Override
        public boolean hasAlpha() {
            return true;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long r = PixelReader.makeShort(inputData, offset) & 0xFFFF;
            long g = PixelReader.makeShort(inputData, offset + 2) & 0xFFFF;
            long b = PixelReader.makeShort(inputData, offset + 4) & 0xFFFF;
            long a = PixelReader.makeShort(inputData, offset + 6) & 0xFFFF;
            return new long[]{r, g, b, a};
        }

        @Override
        public int getPixelSize() {
            return 8;
        }
    };
    static final @NonNull IPixelReader R16G16B16_UI = new IPixelReader(){

        @Override
        public long getRMax() {
            return 65535L;
        }

        @Override
        public long getGMax() {
            return 65535L;
        }

        @Override
        public long getBMax() {
            return 65535L;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long r = PixelReader.makeShort(inputData, offset) & 0xFFFF;
            long g = PixelReader.makeShort(inputData, offset + 2) & 0xFFFF;
            long b = PixelReader.makeShort(inputData, offset + 4) & 0xFFFF;
            long[] lArray = new long[4];
            lArray[0] = r;
            lArray[1] = g;
            lArray[2] = b;
            return lArray;
        }

        @Override
        public int getPixelSize() {
            return 6;
        }
    };
    static final @NonNull IPixelReader R16_UI = new IPixelReader(){

        @Override
        public long getRMax() {
            return 65535L;
        }

        @Override
        public long getGMax() {
            return 65535L;
        }

        @Override
        public long getBMax() {
            return 65535L;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long r = PixelReader.makeShort(inputData, offset) & 0xFFFF;
            long[] lArray = new long[4];
            lArray[0] = r;
            return lArray;
        }

        @Override
        public int getPixelSize() {
            return 2;
        }
    };
    static final @NonNull IPixelReader R16G16_UI = new IPixelReader(){

        @Override
        public long getRMax() {
            return 65535L;
        }

        @Override
        public long getGMax() {
            return 65535L;
        }

        @Override
        public long getBMax() {
            return 65535L;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long r = PixelReader.makeShort(inputData, offset) & 0xFFFF;
            long g = PixelReader.makeShort(inputData, offset + 2) & 0xFFFF;
            long[] lArray = new long[4];
            lArray[0] = r;
            lArray[1] = g;
            return lArray;
        }

        @Override
        public int getPixelSize() {
            return 4;
        }
    };
    static final @NonNull IPixelReader R32G32B32A32_UI = new IPixelReader(){

        @Override
        public long getRMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public long getGMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public long getBMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public long getAMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public boolean hasAlpha() {
            return true;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long r = PixelReader.makeUnsignedInt(inputData, offset) & 0xFFFFFFFFFFFFFFFFL;
            long g = PixelReader.makeUnsignedInt(inputData, offset + 4) & 0xFFFFFFFFFFFFFFFFL;
            long b = PixelReader.makeUnsignedInt(inputData, offset + 8) & 0xFFFFFFFFFFFFFFFFL;
            long a = PixelReader.makeUnsignedInt(inputData, offset + 12) & 0xFFFFFFFFFFFFFFFFL;
            return new long[]{r, g, b, a};
        }

        @Override
        public int getPixelSize() {
            return 16;
        }
    };
    static final @NonNull IPixelReader R32G32B32_UI = new IPixelReader(){

        @Override
        public long getRMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public long getGMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public long getBMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long r = PixelReader.makeUnsignedInt(inputData, offset) & 0xFFFFFFFFFFFFFFFFL;
            long g = PixelReader.makeUnsignedInt(inputData, offset + 4) & 0xFFFFFFFFFFFFFFFFL;
            long b = PixelReader.makeUnsignedInt(inputData, offset + 8) & 0xFFFFFFFFFFFFFFFFL;
            long[] lArray = new long[4];
            lArray[0] = r;
            lArray[1] = g;
            lArray[2] = b;
            return lArray;
        }

        @Override
        public int getPixelSize() {
            return 12;
        }
    };
    static final @NonNull IPixelReader R32G32_UI = new IPixelReader(){

        @Override
        public long getRMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public long getGMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long r = PixelReader.makeUnsignedInt(inputData, offset) & 0xFFFFFFFFFFFFFFFFL;
            long g = PixelReader.makeUnsignedInt(inputData, offset + 4) & 0xFFFFFFFFFFFFFFFFL;
            long[] lArray = new long[4];
            lArray[0] = r;
            lArray[1] = g;
            return lArray;
        }

        @Override
        public int getPixelSize() {
            return 8;
        }
    };
    static final @NonNull IPixelReader R4G4B4A4 = new IPixelReader(){

        @Override
        public long getRMax() {
            return 15L;
        }

        @Override
        public long getGMax() {
            return 15L;
        }

        @Override
        public long getBMax() {
            return 15L;
        }

        @Override
        public long getAMax() {
            return 15L;
        }

        @Override
        public boolean hasAlpha() {
            return true;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            return new long[]{(inputData.get(offset) & 0xF0) >> 4, inputData.get(offset) & 0xF, (inputData.get(offset + 1) & 0xF0) >> 4, inputData.get(offset + 1) & 0xF};
        }

        @Override
        public int getPixelSize() {
            return 2;
        }
    };
    static final @NonNull IPixelReader R32G32B32A32_F = new IPixelReader(){

        @Override
        public long getRMax() {
            return 255L;
        }

        @Override
        public long getGMax() {
            return 255L;
        }

        @Override
        public long getBMax() {
            return 255L;
        }

        @Override
        public long getAMax() {
            return 255L;
        }

        @Override
        public boolean hasAlpha() {
            return true;
        }

        @Override
        public boolean isByteRanged() {
            return true;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            inputData.order(ByteOrder.LITTLE_ENDIAN);
            float r = inputData.getFloat(offset);
            float g = inputData.getFloat(offset + 4);
            float b = inputData.getFloat(offset + 8);
            float a = inputData.getFloat(offset + 12);
            return new long[]{PixelReader.unitFloatToByte(r), PixelReader.unitFloatToByte(g), PixelReader.unitFloatToByte(b), PixelReader.unitFloatToByte(a)};
        }

        @Override
        public int getPixelSize() {
            return 16;
        }
    };
    static final @NonNull IPixelReader R16G16B16A16_F = new IPixelReader(){

        @Override
        public long getRMax() {
            return 255L;
        }

        @Override
        public long getGMax() {
            return 255L;
        }

        @Override
        public long getBMax() {
            return 255L;
        }

        @Override
        public long getAMax() {
            return 255L;
        }

        private double sixteenBitFloatToDouble(int field) {
            if (!$assertionsDisabled && field >= 65536) {
                throw new AssertionError((Object)"Input must have most significant 16 bits as zero");
            }
            int sign = field >> 15 & 1;
            int exponent = field >> 10 & 0x1F;
            int mantissa = field & 0x3FF;
            double signMultiplier = sign == 1 ? -1.0 : 1.0;
            switch (exponent) {
                case 0: {
                    if (mantissa == 0) {
                        return signMultiplier * 0.0;
                    }
                    return signMultiplier * POWER_2_TO_MINUS_24 * (double)mantissa;
                }
                case 31: {
                    if (mantissa == 0) {
                        return signMultiplier > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                    }
                    return Double.NaN;
                }
            }
            return signMultiplier * Math.pow(2.0, (double)exponent - 15.0) * (1.0 + (double)mantissa / POWER_2_TO_10);
        }

        @Override
        public boolean hasAlpha() {
            return true;
        }

        @Override
        public boolean isByteRanged() {
            return true;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            int rawRed = PixelReader.makeShort(inputData, offset);
            int rawGreen = PixelReader.makeShort(inputData, offset + 2);
            int rawBlue = PixelReader.makeShort(inputData, offset + 4);
            int rawAlpha = PixelReader.makeShort(inputData, offset + 6);
            long red = PixelReader.unitDoubleToByte(this.sixteenBitFloatToDouble(rawRed));
            long green = PixelReader.unitDoubleToByte(this.sixteenBitFloatToDouble(rawGreen));
            long blue = PixelReader.unitDoubleToByte(this.sixteenBitFloatToDouble(rawBlue));
            long alpha = PixelReader.unitDoubleToByte(this.sixteenBitFloatToDouble(rawAlpha));
            return new long[]{red, green, blue, alpha};
        }

        @Override
        public int getPixelSize() {
            return 8;
        }
    };
    static final @NonNull IPixelReader B8G8R8A8 = new IPixelReader(){

        @Override
        public long getRMax() {
            return 255L;
        }

        @Override
        public long getGMax() {
            return 255L;
        }

        @Override
        public long getBMax() {
            return 255L;
        }

        @Override
        public long getAMax() {
            return 255L;
        }

        @Override
        public boolean hasAlpha() {
            return true;
        }

        @Override
        public boolean isByteRanged() {
            return true;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            return new long[]{inputData.get(offset + 2) & 0xFF, inputData.get(offset + 1) & 0xFF, inputData.get(offset + 0) & 0xFF, inputData.get(offset + 3) & 0xFF};
        }

        @Override
        public int getPixelSize() {
            return 4;
        }
    };
    static final @NonNull IPixelReader R8G8B8A8 = new IPixelReader(){

        @Override
        public long getRMax() {
            return 255L;
        }

        @Override
        public long getGMax() {
            return 255L;
        }

        @Override
        public long getBMax() {
            return 255L;
        }

        @Override
        public long getAMax() {
            return 255L;
        }

        @Override
        public boolean hasAlpha() {
            return true;
        }

        @Override
        public boolean isByteRanged() {
            return true;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            return new long[]{inputData.get(offset) & 0xFF, inputData.get(offset + 1) & 0xFF, inputData.get(offset + 2) & 0xFF, inputData.get(offset + 3) & 0xFF};
        }

        @Override
        public int getPixelSize() {
            return 4;
        }
    };
    static final @NonNull IPixelReader SRGB8_ALPHA8 = new IPixelReader(){

        @Override
        public long getRMax() {
            return 255L;
        }

        @Override
        public long getGMax() {
            return 255L;
        }

        @Override
        public long getBMax() {
            return 255L;
        }

        @Override
        public long getAMax() {
            return 255L;
        }

        @Override
        public boolean hasAlpha() {
            return true;
        }

        @Override
        public boolean isByteRanged() {
            return true;
        }

        private long convertSRGBComponentToLinear(long srgb) {
            double srgbDouble = (double)srgb / 255.0;
            if (srgbDouble <= 0.04045) {
                return PixelReader.unitDoubleToByte(srgbDouble / 12.92);
            }
            return PixelReader.unitDoubleToByte(Math.pow((srgbDouble + 0.055) / 1.055, 2.4));
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            return new long[]{this.convertSRGBComponentToLinear(inputData.get(offset) & 0xFF), this.convertSRGBComponentToLinear(inputData.get(offset + 1) & 0xFF), this.convertSRGBComponentToLinear(inputData.get(offset + 2) & 0xFF), inputData.get(offset + 3) & 0xFF};
        }

        @Override
        public int getPixelSize() {
            return 4;
        }
    };
    static final @NonNull IPixelReader R11G11B10_UI = new IPixelReader(){

        @Override
        public long getRMax() {
            return 1023L;
        }

        @Override
        public long getGMax() {
            return 2047L;
        }

        @Override
        public long getBMax() {
            return 2047L;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long word = PixelReader.makeInt(inputData, offset) & 0xFFFFFFFF;
            long r = word >> 22 & 0x3FFL;
            long g = word >> 11 & 0x7FFL;
            long b = word >> 0 & 0x7FFL;
            long[] lArray = new long[4];
            lArray[0] = r;
            lArray[1] = g;
            lArray[2] = b;
            return lArray;
        }

        @Override
        public int getPixelSize() {
            return 4;
        }
    };
    static final @NonNull IPixelReader B10G11R11 = new IPixelReader(){

        @Override
        public long getRMax() {
            return 2047L;
        }

        @Override
        public long getGMax() {
            return 2047L;
        }

        @Override
        public long getBMax() {
            return 1023L;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long word = PixelReader.makeUnsignedInt(inputData, offset);
            long b = word >> 22 & 0x3FFL;
            long g = word >> 11 & 0x7FFL;
            long r = word >> 0 & 0x7FFL;
            long[] lArray = new long[4];
            lArray[0] = r;
            lArray[1] = g;
            lArray[2] = b;
            return lArray;
        }

        @Override
        public int getPixelSize() {
            return 4;
        }
    };
    static final @NonNull IPixelReader D16_UNORM = new IPixelReader(){

        @Override
        public long getRMax() {
            return 65535L;
        }

        @Override
        public long getGMax() {
            return 65535L;
        }

        @Override
        public long getBMax() {
            return 65535L;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            int value = PixelReader.makeShort(inputData, offset);
            long[] lArray = new long[4];
            lArray[0] = value;
            lArray[1] = value;
            lArray[2] = value;
            return lArray;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public int getPixelSize() {
            return 2;
        }
    };
    static final @NonNull IPixelReader X8_D24_UNORM_PACK32 = new IPixelReader(){

        @Override
        public long getRMax() {
            return 0xFFFFFFL;
        }

        @Override
        public long getGMax() {
            return 0xFFFFFFL;
        }

        @Override
        public long getBMax() {
            return 0xFFFFFFL;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long word = PixelReader.makeUnsignedInt(inputData, offset);
            long d = word & 0xFFFFFFL;
            long[] lArray = new long[4];
            lArray[0] = d;
            lArray[1] = d;
            lArray[2] = d;
            return lArray;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public int getPixelSize() {
            return 4;
        }
    };
    static final @NonNull IPixelReader D32_SFLOAT = new IPixelReader(){

        @Override
        public long getRMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public long getGMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public long getBMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long r = PixelReader.makeUnsignedInt(inputData, offset) & 0xFFFFFFFFFFFFFFFFL;
            long[] lArray = new long[4];
            lArray[0] = r;
            lArray[1] = r;
            lArray[2] = r;
            return lArray;
        }

        @Override
        public int getPixelSize() {
            return 4;
        }
    };
    static final @NonNull IPixelReader D16_UNORM_S8_UINT = new IPixelReader(){

        @Override
        public long getRMax() {
            return 65535L;
        }

        @Override
        public long getGMax() {
            return 65535L;
        }

        @Override
        public long getBMax() {
            return 65535L;
        }

        @Override
        public long getAMax() {
            return 255L;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            int value = PixelReader.makeShort(inputData, offset);
            return new long[]{value, value, value, inputData.get(offset + 2) & 0xFF};
        }

        @Override
        public boolean hasAlpha() {
            return true;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public int getPixelSize() {
            return 3;
        }
    };
    static final @NonNull IPixelReader D24_UNORM_S8_UINT = new IPixelReader(){

        @Override
        public long getRMax() {
            return 0xFFFFFFL;
        }

        @Override
        public long getGMax() {
            return 0xFFFFFFL;
        }

        @Override
        public long getBMax() {
            return 0xFFFFFFL;
        }

        @Override
        public long getAMax() {
            return 255L;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long word = PixelReader.makeUnsignedInt(inputData, offset) & 0xFFFFFFL;
            return new long[]{word, word, word, inputData.get(offset + 3) & 0xFF};
        }

        @Override
        public boolean hasAlpha() {
            return true;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public int getPixelSize() {
            return 4;
        }
    };
    static final @NonNull IPixelReader D32_SFLOAT_S8_UINT = new IPixelReader(){

        @Override
        public long getRMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public long getGMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public long getBMax() {
            return 0xFFFFFFFFL;
        }

        @Override
        public long getAMax() {
            return 255L;
        }

        @Override
        public boolean hasAlpha() {
            return true;
        }

        @Override
        public boolean isByteRanged() {
            return false;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long r = PixelReader.makeUnsignedInt(inputData, offset) & 0xFFFFFFFFFFFFFFFFL;
            return new long[]{r, r, r, inputData.get(offset + 4) & 0xFF};
        }

        @Override
        public int getPixelSize() {
            return 5;
        }
    };
    static final @NonNull IPixelReader R11G11B10_F = new IPixelReader(){

        private double convertMinifloat(int exponent, int mantissa, MinifloatSize size) {
            if (exponent == 0) {
                return mantissa == 0 ? 0.0 : POWER_2_TO_MINUS_14 * ((double)mantissa / size.getDenominator());
            }
            if (exponent == 31) {
                return mantissa == 0 ? Double.POSITIVE_INFINITY : Double.NaN;
            }
            return Math.pow(2.0, exponent - 15) * (1.0 + (double)mantissa / size.getDenominator());
        }

        private double convertElevenBitField(long field) {
            if (!$assertionsDisabled && field >= 2047L) {
                throw new AssertionError();
            }
            int exponent = (int)(field >> 6);
            int mantissa = (int)(field & 0x3FL);
            if (!$assertionsDisabled && exponent >= 32) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && mantissa >= 64) {
                throw new AssertionError();
            }
            return this.convertMinifloat(exponent, mantissa, MinifloatSize.ElevenBit);
        }

        private double convertTenBitField(long field) {
            if (!$assertionsDisabled && field >= 1023L) {
                throw new AssertionError();
            }
            int exponent = (int)(field >> 5);
            int mantissa = (int)(field & 0x1FL);
            if (!$assertionsDisabled && exponent >= 32) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && mantissa >= 32) {
                throw new AssertionError();
            }
            return this.convertMinifloat(exponent, mantissa, MinifloatSize.TenBit);
        }

        @Override
        public long getRMax() {
            return 255L;
        }

        @Override
        public long getGMax() {
            return 255L;
        }

        @Override
        public long getBMax() {
            return 255L;
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }

        @Override
        public boolean isByteRanged() {
            return true;
        }

        @Override
        public long[] getPixelData(@NonNull ByteBuffer inputData, int offset) {
            long word = PixelReader.makeUnsignedInt(inputData, offset);
            long thirdComponentBits = word >> 22 & 0x3FFL;
            long secondComponentBits = word >> 11 & 0x7FFL;
            long firstComponentBits = word & 0x7FFL;
            double b = this.convertTenBitField(thirdComponentBits);
            double g = this.convertElevenBitField(secondComponentBits);
            double r = this.convertElevenBitField(firstComponentBits);
            long[] lArray = new long[4];
            lArray[0] = PixelReader.unitDoubleToByte(r);
            lArray[1] = PixelReader.unitDoubleToByte(g);
            lArray[2] = PixelReader.unitDoubleToByte(b);
            return lArray;
        }

        @Override
        public int getPixelSize() {
            return 4;
        }
    };
    static final @NonNull IPixelReader R32_F = R32_UI;
    static final @NonNull IPixelReader R32G32B32_F = R32G32B32_UI;
    static final @NonNull IPixelReader R32G32_F = R32G32_UI;
    static final @NonNull IPixelReader R16G16B16_F = R16G16B16_UI;
    static final @NonNull IPixelReader R8_F = R8;
    static final @NonNull IPixelReader R16_F = R16_UI;
    static final @NonNull IPixelReader R16G16_F = R16G16_UI;
    static final @NonNull IPixelReader R8_UNORM = R8;
    static final @NonNull IPixelReader R8G8B8A8_UNORM = R8G8B8A8;
    static final @NonNull IPixelReader R8G8B8A8_SRGB = R8G8B8A8;
    static final @NonNull IPixelReader B8G8R8A8_UNORM = B8G8R8A8;
    static final @NonNull IPixelReader R16_SFLOAT = R16_F;
    static final @NonNull IPixelReader R16G16_SFLOAT = R16G16_F;
    static final @NonNull IPixelReader R16G16B16A16_SFLOAT = R16G16B16A16_F;
    static final @NonNull IPixelReader R32G32B32A32_SFLOAT = R32G32B32A32_F;
    static final @NonNull IPixelReader R32G32B32A32_UINT = R32G32B32A32_UI;
    static final @NonNull IPixelReader A2R10G10B10_UNORM_PACK32 = A2R10G10B10_UI;
    static final @NonNull IPixelReader A2B10G10R10_UNORM_PACK32 = A2B10G10R10_UI;
    static final @NonNull IPixelReader R32_SFLOAT = R32_F;
    static final @NonNull IPixelReader B10G11R11_UFLOAT_PACK32 = B10G11R11;
    static final @NonNull IPixelReader S8_UINT = R8;
    private static final int ONE_BIT_MASK = 1;
    private static final int FIVE_BIT_MASK = 31;
    private static final int SIX_BIT_MASK = 63;
    private static final int TEN_BIT_MASK = 1023;
    private static final int ELEVEN_BIT_MASK = 2047;
    private static final double POWER_2_TO_MINUS_24 = Math.pow(2.0, -24.0);
    private static final double POWER_2_TO_MINUS_14 = Math.pow(2.0, -14.0);
    private static final double POWER_2_TO_10 = Math.pow(2.0, 10.0);

    private static long makeUnsignedInt(@NonNull ByteBuffer data, int offset) {
        return (long)data.get(offset + 0) & 0xFFL | ((long)data.get(offset + 1) & 0xFFL) << 8 | ((long)data.get(offset + 2) & 0xFFL) << 16 | ((long)data.get(offset + 3) & 0xFFL) << 24;
    }

    private static int makeInt(@NonNull ByteBuffer data, int offset) {
        return data.get(offset + 0) & 0xFF | (data.get(offset + 1) & 0xFF) << 8 | (data.get(offset + 2) & 0xFF) << 16 | (data.get(offset + 3) & 0xFF) << 24;
    }

    private static int makeShort(@NonNull ByteBuffer data, int offset) {
        return data.get(offset + 0) & 0xFF | (data.get(offset + 1) & 0xFF) << 8;
    }

    private static long unitDoubleToByte(double in) {
        return Math.min(255L, Math.max(0L, Math.round(in * 255.0)));
    }

    private static long unitFloatToByte(float in) {
        return Math.min(255L, Math.max(0L, (long)Math.round(in * 255.0f)));
    }

    public static interface IPixelReader {
        default public long getRMax() {
            return 0L;
        }

        default public long getRMin() {
            return 0L;
        }

        default public long getGMax() {
            return 0L;
        }

        default public long getGMin() {
            return 0L;
        }

        default public long getBMax() {
            return 0L;
        }

        default public long getBMin() {
            return 0L;
        }

        default public long getAMax() {
            return 0L;
        }

        default public long getAMin() {
            return 0L;
        }

        default public long[] getPixelData(@NonNull ByteBuffer inputData, int width, int x, int y) {
            int offset = (width * y + x) * this.getPixelSize();
            return this.getPixelData(inputData, offset);
        }

        public int getPixelSize();

        public long[] getPixelData(@NonNull ByteBuffer var1, int var2);

        public boolean hasAlpha();

        public boolean isByteRanged();
    }

    static enum MinifloatSize {
        TenBit(32.0),
        ElevenBit(64.0);

        private double denominator;

        private MinifloatSize(double denominator) {
            this.denominator = denominator;
        }

        public double getDenominator() {
            return this.denominator;
        }
    }
}

