/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util.image;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.image.PixelReader;
import com.arm.mgd.core.util.image.PixelScaler;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class IntegerTextureConverter {
    private static final @NonNull Map<AbstractConstantOrAliasSpecExtended, ImageConversionSpec> VULKAN_PIXEL_READER_RANGE_MODES = new HashMap<AbstractConstantOrAliasSpecExtended, ImageConversionSpec>();

    static {
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_R8_UNORM, new ImageConversionSpec(PixelReader.R8_UNORM, PixelScaler.RangeMode.NO_DYNAMIC_RANGE));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_R8G8B8A8_UNORM, new ImageConversionSpec(PixelReader.R8G8B8A8_UNORM, PixelScaler.RangeMode.NO_DYNAMIC_RANGE));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_R8G8B8A8_SRGB, new ImageConversionSpec(PixelReader.R8G8B8A8_SRGB, PixelScaler.RangeMode.NO_DYNAMIC_RANGE));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_B8G8R8A8_UNORM, new ImageConversionSpec(PixelReader.B8G8R8A8_UNORM, PixelScaler.RangeMode.NO_DYNAMIC_RANGE));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_R16_SFLOAT, new ImageConversionSpec(PixelReader.R16_SFLOAT, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_R16G16_SFLOAT, new ImageConversionSpec(PixelReader.R16G16_SFLOAT, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_R16G16B16A16_SFLOAT, new ImageConversionSpec(PixelReader.R16G16B16A16_SFLOAT, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_R32_SFLOAT, new ImageConversionSpec(PixelReader.R32_SFLOAT, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_R32G32B32A32_SFLOAT, new ImageConversionSpec(PixelReader.R32G32B32A32_SFLOAT, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_R32G32B32A32_UINT, new ImageConversionSpec(PixelReader.R32G32B32A32_UINT, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_A2B10G10R10_UNORM_PACK32, new ImageConversionSpec(PixelReader.A2B10G10R10_UNORM_PACK32, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS_DONT_SCALE_ALPHA));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_A2R10G10B10_UNORM_PACK32, new ImageConversionSpec(PixelReader.A2R10G10B10_UNORM_PACK32, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS_DONT_SCALE_ALPHA));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_B10G11R11_UFLOAT_PACK32, new ImageConversionSpec(PixelReader.B10G11R11_UFLOAT_PACK32, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_D16_UNORM, new ImageConversionSpec(PixelReader.D16_UNORM, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_X8_D24_UNORM_PACK32, new ImageConversionSpec(PixelReader.X8_D24_UNORM_PACK32, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_D32_SFLOAT, new ImageConversionSpec(PixelReader.D32_SFLOAT, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_S8_UINT, new ImageConversionSpec(PixelReader.S8_UINT, PixelScaler.RangeMode.NO_DYNAMIC_RANGE));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_D16_UNORM_S8_UINT, new ImageConversionSpec(PixelReader.D16_UNORM_S8_UINT, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS_DONT_SCALE_ALPHA));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_D24_UNORM_S8_UINT, new ImageConversionSpec(PixelReader.D24_UNORM_S8_UINT, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS_DONT_SCALE_ALPHA));
        VULKAN_PIXEL_READER_RANGE_MODES.put(KapiSpec.VULKAN.constants.VK_FORMAT_D32_SFLOAT_S8_UINT, new ImageConversionSpec(PixelReader.D32_SFLOAT_S8_UINT, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS_DONT_SCALE_ALPHA));
    }

    public static @NonNull Result convertTextureData(@NonNull ByteBuffer data, @NonNull Dimension size, @NonNull ImageConversionSpec conversionSpec, @NonNull AlphaChannel alphaMode) {
        return IntegerTextureConverter.convertTextureData(data, size, conversionSpec, alphaMode, 0);
    }

    public static @NonNull Result convertTextureData(@NonNull ByteBuffer data, @NonNull Dimension size, @NonNull ImageConversionSpec conversionSpec, @NonNull AlphaChannel alphaMode, int rowPitch) {
        int height = size.getHeight();
        int width = size.getWidth();
        PixelReader.IPixelReader pixelReader = conversionSpec.pixelReader;
        PixelScaler.RangeMode rangeMode = conversionSpec.rangeMode;
        long aMin = 0xFFFFFFFFL;
        long aMax = 0L;
        long rMin = 0xFFFFFFFFL;
        long rMax = 0L;
        long gMin = 0xFFFFFFFFL;
        long gMax = 0L;
        long bMin = 0xFFFFFFFFL;
        long bMax = 0L;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                long[] pixelData;
                if (rowPitch > 0) {
                    int pixelSize = pixelReader.getPixelSize();
                    int offset = y * rowPitch + x * pixelSize;
                    pixelData = pixelReader.getPixelData(data, offset);
                } else {
                    pixelData = pixelReader.getPixelData(data, width, x, y);
                }
                if (pixelData[3] != 0L || pixelData[0] != 0L) {
                    rMin = Math.min(rMin, pixelData[0]);
                    rMax = Math.max(rMax, pixelData[0]);
                }
                if (pixelData[3] != 0L || pixelData[1] != 0L) {
                    gMin = Math.min(gMin, pixelData[1]);
                    gMax = Math.max(gMax, pixelData[1]);
                }
                if (pixelData[3] != 0L || pixelData[2] != 0L) {
                    bMin = Math.min(bMin, pixelData[2]);
                    bMax = Math.max(bMax, pixelData[2]);
                }
                aMin = Math.min(aMin, pixelData[3]);
                aMax = Math.max(aMax, pixelData[3]);
                ++x;
            }
            ++y;
        }
        PixelScaler.IPixelScaler pixelScaler = PixelScaler.getPixelScaler(rangeMode, pixelReader, new long[]{rMin, gMin, bMin, aMin}, new long[]{rMax, gMax, bMax, aMax});
        int bytesPerPixel = alphaMode == AlphaChannel.INLINE_ALPHA ? 4 : 3;
        byte[] outputData = new byte[bytesPerPixel * width * height];
        byte[] alphaData = alphaMode == AlphaChannel.SEPARATE_ALPHA ? new byte[width * height] : null;
        int writeOffset = 0;
        int alphaOffset = 0;
        int y2 = 0;
        while (y2 < height) {
            int x = 0;
            while (x < width) {
                int alphaValue;
                long[] pixelData;
                if (rowPitch > 0) {
                    int pixelSize = pixelReader.getPixelSize();
                    int offset = y2 * rowPitch + x * pixelSize;
                    pixelData = pixelReader.getPixelData(data, offset);
                } else {
                    pixelData = pixelReader.getPixelData(data, width, x, y2);
                }
                byte[] outputPixels = pixelScaler.scalePixel(pixelData);
                System.arraycopy(outputPixels, 0, outputData, writeOffset, 3);
                int n = alphaValue = pixelReader.hasAlpha() ? outputPixels[3] : -1;
                if (alphaMode == AlphaChannel.INLINE_ALPHA) {
                    outputData[writeOffset + 3] = alphaValue;
                } else if (alphaMode == AlphaChannel.SEPARATE_ALPHA) {
                    assert (alphaData != null);
                    alphaData[alphaOffset] = alphaValue;
                }
                writeOffset += bytesPerPixel;
                ++alphaOffset;
                ++x;
            }
            ++y2;
        }
        if (alphaMode == AlphaChannel.SEPARATE_ALPHA) {
            assert (alphaData != null);
            return new Result(width, height, outputData, alphaData);
        }
        return new Result(width, height, outputData, alphaMode == AlphaChannel.INLINE_ALPHA);
    }

    public static Result convertOpenGLESTextureData(@NonNull ByteBuffer data, @NonNull Dimension size, @NonNull AbstractConstantOrAliasSpecExtended format, @NonNull AbstractConstantOrAliasSpecExtended type, @Nullable AbstractConstantOrAliasSpecExtended internalFormat, @NonNull AlphaChannel alphaMode) {
        ImageConversionSpec conversionSpec = IntegerTextureConverter.getOpenGLESImageConversionSpec(format, type, internalFormat);
        if (conversionSpec == null) {
            return null;
        }
        return IntegerTextureConverter.convertTextureData(data, size, conversionSpec, alphaMode);
    }

    public static @NonNull PixelReader.IPixelReader getRGBA8PixelReader() {
        return ((ImageConversionSpec)NullUtils.neverNull((Object)IntegerTextureConverter.getOpenGLESImageConversionSpec((AbstractConstantOrAliasSpecExtended)KapiSpec.GLES.constants.GL_RGBA, (AbstractConstantOrAliasSpecExtended)KapiSpec.GLES.constants.GL_UNSIGNED_BYTE, null))).pixelReader;
    }

    public static @Nullable ImageConversionSpec getVulkanImageConversionSpec(AbstractConstantOrAliasSpecExtended type) {
        return VULKAN_PIXEL_READER_RANGE_MODES.get(type);
    }

    private static @NonNull PixelReader.IPixelReader getAppropriateRGBA8PixelReader(@Nullable AbstractConstantOrAliasSpecExtended internalFormat) {
        return Objects.equals(internalFormat, KapiSpec.GLES.constants.GL_SRGB8_ALPHA8) ? PixelReader.SRGB8_ALPHA8 : PixelReader.R8G8B8A8;
    }

    public static @Nullable ImageConversionSpec getOpenGLESImageConversionSpec(AbstractConstantOrAliasSpecExtended format, AbstractConstantOrAliasSpecExtended type, @Nullable AbstractConstantOrAliasSpecExtended internalFormat) {
        if (KapiSpec.GLES.constants.GL_RGBA_INTEGER.equals(format)) {
            if (KapiSpec.GLES.constants.GL_UNSIGNED_INT.equals(type)) {
                return new ImageConversionSpec(PixelReader.R32G32B32A32_UI, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS);
            }
            if (KapiSpec.GLES.constants.GL_UNSIGNED_SHORT.equals(type)) {
                return new ImageConversionSpec(PixelReader.R16G16B16A16_UI, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS);
            }
            if (KapiSpec.GLES.constants.GL_UNSIGNED_INT_2_10_10_10_REV.equals(type)) {
                return new ImageConversionSpec(PixelReader.A2B10G10R10_UI, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS_DONT_SCALE_ALPHA);
            }
        } else if (KapiSpec.GLES.constants.GL_RGBA.equals(format)) {
            if (KapiSpec.GLES.constants.GL_UNSIGNED_BYTE.equals(type)) {
                return new ImageConversionSpec(IntegerTextureConverter.getAppropriateRGBA8PixelReader(internalFormat), PixelScaler.RangeMode.NO_DYNAMIC_RANGE);
            }
            if (KapiSpec.GLES.constants.GL_UNSIGNED_SHORT_4_4_4_4.equals(type)) {
                return new ImageConversionSpec(PixelReader.R4G4B4A4, PixelScaler.RangeMode.NO_DYNAMIC_RANGE);
            }
            if (KapiSpec.GLES.constants.GL_UNSIGNED_INT_2_10_10_10_REV.equals(type)) {
                return new ImageConversionSpec(PixelReader.A2B10G10R10_UI, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS_DONT_SCALE_ALPHA);
            }
            if (KapiSpec.GLES.constants.GL_HALF_FLOAT.equals(type)) {
                return new ImageConversionSpec(PixelReader.R16G16B16A16_F, PixelScaler.RangeMode.NO_DYNAMIC_RANGE);
            }
            if (KapiSpec.GLES.constants.GL_FLOAT.equals(type)) {
                return new ImageConversionSpec(PixelReader.R32G32B32A32_F, PixelScaler.RangeMode.NO_DYNAMIC_RANGE);
            }
        } else if (KapiSpec.GLES.constants.GL_RGB.equals(format)) {
            if (KapiSpec.GLES.constants.GL_UNSIGNED_SHORT_5_6_5.equals(type)) {
                return new ImageConversionSpec(PixelReader.R5G6B5, PixelScaler.RangeMode.NO_DYNAMIC_RANGE);
            }
            if (KapiSpec.GLES.constants.GL_UNSIGNED_BYTE.equals(type)) {
                return new ImageConversionSpec(PixelReader.R8G8B8, PixelScaler.RangeMode.NO_DYNAMIC_RANGE);
            }
            if (KapiSpec.GLES.constants.GL_UNSIGNED_INT_10F_11F_11F_REV.equals(type)) {
                return new ImageConversionSpec(PixelReader.R11G11B10_F, PixelScaler.RangeMode.NO_DYNAMIC_RANGE);
            }
            if (KapiSpec.GLES.constants.GL_HALF_FLOAT.equals(type)) {
                return new ImageConversionSpec(PixelReader.R16G16B16_F, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS);
            }
            if (KapiSpec.GLES.constants.GL_FLOAT.equals(type)) {
                return new ImageConversionSpec(PixelReader.R32G32B32_F, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS);
            }
        } else if (KapiSpec.GLES.constants.GL_RG.equals(format)) {
            if (KapiSpec.GLES.constants.GL_HALF_FLOAT.equals(type)) {
                return new ImageConversionSpec(PixelReader.R16G16_F, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS);
            }
            if (KapiSpec.GLES.constants.GL_FLOAT.equals(type)) {
                return new ImageConversionSpec(PixelReader.R32G32_F, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS);
            }
        } else if (KapiSpec.GLES.constants.GL_RG_INTEGER.equals(format)) {
            if (KapiSpec.GLES.constants.GL_UNSIGNED_SHORT.equals(type)) {
                return new ImageConversionSpec(PixelReader.R16G16_UI, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS);
            }
        } else if (KapiSpec.GLES.constants.GL_RED_INTEGER.equals(format)) {
            if (KapiSpec.GLES.constants.GL_UNSIGNED_BYTE.equals(type)) {
                return new ImageConversionSpec(PixelReader.R8, PixelScaler.RangeMode.NO_DYNAMIC_RANGE);
            }
            if (KapiSpec.GLES.constants.GL_INT.equals(type)) {
                return new ImageConversionSpec(PixelReader.R32_UI, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS);
            }
            if (KapiSpec.GLES.constants.GL_UNSIGNED_SHORT.equals(type)) {
                return new ImageConversionSpec(PixelReader.R16_UI, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS);
            }
        } else if (KapiSpec.GLES.constants.GL_RED.equals(format)) {
            if (KapiSpec.GLES.constants.GL_UNSIGNED_BYTE.equals(type)) {
                return new ImageConversionSpec(PixelReader.R8, PixelScaler.RangeMode.NO_DYNAMIC_RANGE);
            }
            if (KapiSpec.GLES.constants.GL_HALF_FLOAT.equals(type)) {
                return new ImageConversionSpec(PixelReader.R16_F, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS);
            }
            if (KapiSpec.GLES.constants.GL_FLOAT.equals(type)) {
                return new ImageConversionSpec(PixelReader.R32_F, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE_RETAIN_ALL_CHANNELS);
            }
        } else if (KapiSpec.GLES.constants.GL_STENCIL_INDEX.equals(format)) {
            if (KapiSpec.GLES.constants.GL_STENCIL_INDEX8.equals(type)) {
                return new ImageConversionSpec(PixelReader.R8, PixelScaler.RangeMode.NO_DYNAMIC_RANGE);
            }
        } else if (KapiSpec.GLES.constants.GL_DEPTH_COMPONENT.equals(format) && KapiSpec.GLES.constants.GL_DEPTH_COMPONENT16.equals(type)) {
            return new ImageConversionSpec(PixelReader.DEPTH_COMPONENT16, PixelScaler.RangeMode.PER_CHANNEL_DYNAMIC_RANGE);
        }
        return null;
    }

    public static enum AlphaChannel {
        INLINE_ALPHA,
        NO_ALPHA,
        SEPARATE_ALPHA;

    }

    public static class ImageConversionSpec {
        public final @NonNull PixelReader.IPixelReader pixelReader;
        public final @NonNull PixelScaler.RangeMode rangeMode;

        private ImageConversionSpec(@NonNull PixelReader.IPixelReader pixelReader, @NonNull PixelScaler.RangeMode rangeMode) {
            this.pixelReader = pixelReader;
            this.rangeMode = rangeMode;
        }
    }

    public static class Result {
        private final byte @Nullable [] alphaData;
        private final byte @NonNull [] data;
        private final boolean hasAlphaChannel;
        private final int height;
        private final int width;

        private Result(int width, int height, byte @NonNull [] data, boolean hasAlphaChannel) {
            this.width = width;
            this.height = height;
            this.data = data;
            this.alphaData = null;
            this.hasAlphaChannel = hasAlphaChannel;
        }

        private Result(int width, int height, byte @NonNull [] data, byte @NonNull [] alphaData) {
            this.width = width;
            this.height = height;
            this.data = data;
            this.alphaData = alphaData;
            this.hasAlphaChannel = true;
        }

        public byte @Nullable [] getAlphaData() {
            return this.alphaData;
        }

        public byte @NonNull [] getData() {
            return this.data;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isHasAlphaChannel() {
            return this.hasAlphaChannel;
        }
    }
}

