/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util.executors;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;

public class NamedThreadPoolExecutor
extends ThreadPoolExecutor {
    NamedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, @NonNull TimeUnit unit, @NonNull BlockingQueue<Runnable> workQueue, @NonNull NamedThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.allowCoreThreadTimeOut(true);
    }

    @Override
    public @NonNull NamedThreadFactory getThreadFactory() {
        ThreadFactory threadFactory = super.getThreadFactory();
        assert (threadFactory instanceof NamedThreadFactory);
        return (NamedThreadFactory)threadFactory;
    }

    @Override
    public void execute(Runnable command) {
        Runnable wrappedCommand = () -> {
            try {
                command.run();
            }
            catch (Throwable t) {
                String threadName = Thread.currentThread().getName();
                CoreLogging.warning(null, t, "Runnable " + command.toString() + " executed by thread " + threadName + " threw an exception");
            }
        };
        boolean rejected = false;
        do {
            rejected = false;
            try {
                super.execute(wrappedCommand);
            }
            catch (RejectedExecutionException e) {
                if (!this.isShutdown()) {
                    rejected = true;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw e;
            }
        } while (rejected);
    }
}

