/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util.executors;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.NonNull;

public class NamedThreadFactory
implements ThreadFactory {
    final ThreadGroup group;
    final String poolName;
    final int priority;
    final @NonNull AtomicInteger threadIndex = new AtomicInteger(0);

    public NamedThreadFactory(String poolName) {
        this(poolName, 5);
    }

    public NamedThreadFactory(String poolName, int priority) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.poolName = poolName;
        this.priority = priority;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, String.valueOf(this.poolName) + " " + this.threadIndex.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != this.priority) {
            t.setPriority(this.priority);
        }
        return t;
    }

    public String getPoolName() {
        return this.poolName;
    }
}

