/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util.executors;

import com.arm.mgd.utils.NullUtils;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.jdt.annotation.NonNull;

public class NamedSingleThreadExecutor {
    private final @NonNull ExecutorService executor;
    private final long executorThreadID;

    public NamedSingleThreadExecutor(@NonNull String label, boolean isDaemon) {
        Long threadID;
        block2: {
            this.executor = (ExecutorService)NullUtils.neverNull((Object)Executors.newSingleThreadExecutor(runnable -> {
                Thread t = new Thread(runnable, label);
                t.setDaemon(isDaemon);
                return t;
            }));
            threadID = -1L;
            try {
                threadID = this.executor.submit(() -> Thread.currentThread().getId()).get();
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.executorThreadID = threadID;
    }

    public @NonNull Future<?> runLater(@NonNull Runnable runnable) {
        return (Future)NullUtils.neverNull(this.executor.submit(() -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }));
    }

    public <T> @NonNull Future<T> runLater(@NonNull Callable<T> callable, T defaultReturn) {
        return (Future)NullUtils.neverNull(this.executor.submit(() -> {
            try {
                return callable.call();
            }
            catch (Throwable t) {
                t.printStackTrace();
                return defaultReturn;
            }
        }));
    }

    public boolean isCurrentThread() {
        return Thread.currentThread().getId() == this.executorThreadID;
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    public @NonNull List<Runnable> shutdownNow() {
        return (List)NullUtils.neverNull(this.executor.shutdownNow());
    }
}

