/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util.deviceinfo;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.utils.NullUtils;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;

public class EglConfigInfo {
    private static final String QUERY_NAME = "query-configs";
    private final @NonNull Map<@NonNull String, @NonNull String> attribs;
    private final @NonNull String label;

    public EglConfigInfo(@NonNull String queryResponse) {
        if (queryResponse.isEmpty() || !queryResponse.startsWith(QUERY_NAME)) {
            throw new IllegalArgumentException("Illegal query response");
        }
        this.attribs = Pattern.compile("\\s*,\\s*").splitAsStream(queryResponse.trim()).map(element -> element.split(":")).filter(EglConfigInfo::isAttributeValid).collect(Collectors.toMap(attrib -> KapiSpec.EGL.getConstantSpecByValue(Long.valueOf(attrib[0])).toString(), attrib -> attrib[1]));
        this.label = this.attribs.get("EGL_CONFIG_ID");
    }

    private static boolean isAttributeValid(String[] attrib) {
        if (attrib == null) {
            return false;
        }
        if (attrib.length < 2) {
            return false;
        }
        if (attrib[0].startsWith(QUERY_NAME)) {
            return false;
        }
        return attrib[1].matches("\\d+");
    }

    public @NonNull String getAttrib(@NonNull String name) {
        return (String)NullUtils.nonNullOrDefault((Object)this.attribs.get(name), (Object)"");
    }

    public @NonNull Map<@NonNull String, @NonNull String> getAttribs() {
        return NullUtils.unmodifiableMap(this.attribs);
    }

    public @NonNull String getLabel() {
        return this.label;
    }
}

