/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;

public class WeakListenerSet<T> {
    private Set<WeakReference<T>> listeners = new HashSet<WeakReference<T>>();

    public synchronized void notifyWeakListeners(@NonNull Consumer<@NonNull T> listenerAction) {
        ArrayList<WeakReference<T>> toRemove = new ArrayList<WeakReference<T>>();
        for (WeakReference<T> weakReference : this.listeners) {
            Object listener = weakReference.get();
            if (listener != null) {
                listenerAction.accept(listener);
                continue;
            }
            toRemove.add(weakReference);
        }
        this.listeners.removeAll(toRemove);
    }

    public synchronized void removeWeakReference(@NonNull T objectToRemove) {
        ArrayList<WeakReference<T>> toRemove = new ArrayList<WeakReference<T>>();
        for (WeakReference<T> weakReference : this.listeners) {
            Object referencedItem = weakReference.get();
            if (referencedItem != null && !referencedItem.equals(objectToRemove)) continue;
            toRemove.add(weakReference);
        }
        this.listeners.removeAll(toRemove);
    }

    public synchronized void addListenerAsWeakReference(@NonNull T listenerToAdd) {
        this.listeners.add(new WeakReference<T>(listenerToAdd));
    }

    public synchronized void clear() {
        this.listeners.clear();
    }
}

