/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.traceanalyses.TraceAnalysis;
import com.arm.mgd.core.traceanalyses.TraceAnalysisModel;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TraceAnalysisLogger {
    public static void error(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull Throwable throwable, @Nullable String message) {
        TraceAnalysisLogger.error(currentState, functionCall, TraceAnalysisLogger.getThrowableMessage(throwable, message));
    }

    public static void error(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull String message) {
        TraceAnalysisLogger.error(currentState, functionCall, message, "");
    }

    public static void error(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull String message, @NonNull String description) {
        TraceAnalysisLogger.createTraceAnalysis(TraceAnalysis.AnalysisType.ERROR, currentState, functionCall, message, description);
    }

    public static void warning(@NonNull TraceStateSnapshot currentState, @Nullable FunctionCall functionCall, @NonNull Throwable throwable, @Nullable String message) {
        TraceAnalysisLogger.warning(currentState, functionCall, TraceAnalysisLogger.getThrowableMessage(throwable, message));
    }

    public static void warning(@NonNull TraceStateSnapshot currentState, @Nullable FunctionCall functionCall, @NonNull String message) {
        TraceAnalysisLogger.warning(currentState, functionCall, message, "");
    }

    public static void warning(@NonNull TraceStateSnapshot currentState, @Nullable FunctionCall functionCall, @NonNull String message, @NonNull String description) {
        TraceAnalysisLogger.createTraceAnalysis(TraceAnalysis.AnalysisType.WARNING, currentState, functionCall, message, description);
    }

    public static void info(@NonNull TraceStateSnapshot currentState, @Nullable FunctionCall functionCall, @NonNull String msg, @NonNull String description) {
        TraceAnalysisLogger.createTraceAnalysis(TraceAnalysis.AnalysisType.INFO, currentState, functionCall, msg, description);
    }

    private static void createTraceAnalysis( @NonNull TraceAnalysis.AnalysisType problemType, @NonNull TraceStateSnapshot currentState, @Nullable FunctionCall functionCall, @NonNull String message, @NonNull String description) {
        TraceAnalysisModel model = currentState.getTraceAnalysisModel();
        if (model != null) {
            model.addAnalysis(problemType, message, description, functionCall);
        }
    }

    private static @NonNull String getThrowableMessage(@NonNull Throwable throwable, @Nullable String msg) {
        String throwableMsg = throwable.getMessage();
        if (throwableMsg == null) {
            throwableMsg = (String)NullUtils.neverNull((Object)throwable.toString());
        }
        return msg == null ? throwableMsg : String.valueOf(msg) + ": " + throwableMsg;
    }
}

