/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class Timestamp {
    private static final int CACHE_MAX_SIZE = 100;
    private static final Map<Long, String> cache = new LinkedHashMap<Long, String>(100, 0.75f, false){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, String> eldest) {
            return this.size() > 100;
        }
    };

    public static long stringToMicroseconds(String formattedString) {
        BigDecimal bigDecimal = new BigDecimal(formattedString);
        assert (bigDecimal.signum() >= 0);
        BigDecimal bigDecimalMoved = bigDecimal.movePointRight(6);
        return bigDecimalMoved.longValue();
    }

    public static String prettyDecimalTimeString(long microseconds) {
        StringBuilder sb = new StringBuilder();
        long seconds = microseconds / 1000000L;
        long useconds = microseconds % 1000000L;
        sb.append(Timestamp.getFormattedTimeString(seconds)).append('.').append(String.format("%06d", useconds));
        return sb.toString();
    }

    private static String getFormattedTimeString(long seconds) {
        Long secondsLong = seconds;
        String dateStr = cache.get(secondsLong);
        if (dateStr == null) {
            Date dateSeconds = new Date(seconds * 1000L);
            dateStr = new SimpleDateFormat("HH:mm:ss").format(dateSeconds);
            cache.put(secondsLong, dateStr);
        }
        return dateStr;
    }

    public static String microsecondsToString(long microseconds) {
        return String.format("%d.%06d", microseconds / 1000000L, microseconds % 1000000L);
    }
}

