/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TextureAssetUtils {
    public static final int CUBE_MAP_CROSS_SURFACE_ID = -1;
    public static final Set<@NonNull AbstractConstantOrAliasSpecExtended> CUBE_MAP_FACE_TARGETS = new HashSet<AbstractConstantOrAliasSpecExtended>(){
        {
            this.add(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_NEGATIVE_X);
            this.add(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_NEGATIVE_Y);
            this.add(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_NEGATIVE_Z);
            this.add(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_POSITIVE_X);
            this.add(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_POSITIVE_Y);
            this.add(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_POSITIVE_Z);
        }
    };
    public static final Map<Long, String> CUBEMAP_EXPORT_ID_LABEL = new HashMap<Long, String>(){
        {
            this.put(-1L, "");
            this.put(5L, "_POSITIVE_X");
            this.put(6L, "_NEGATIVE_X");
            this.put(7L, "_POSITIVE_Y");
            this.put(8L, "_NEGATIVE_Y");
            this.put(9L, "_POSITIVE_Z");
            this.put(10L, "_NEGATIVE_Z");
        }
    };
    public static final int CUBEMAP_NEGATIVE_X_ID = 1;
    public static final int CUBEMAP_NEGATIVE_Y_ID = 3;
    public static final int CUBEMAP_NEGATIVE_Z_ID = 5;
    public static final int CUBEMAP_POSITIVE_X_ID = 0;
    public static final int CUBEMAP_POSITIVE_Y_ID = 2;
    public static final int CUBEMAP_POSITIVE_Z_ID = 4;
    private static final Map<AbstractConstantOrAliasSpecExtended, Long> MAP_TARGET_TO_SURFACE_ID = new HashMap<AbstractConstantOrAliasSpecExtended, Long>(){
        {
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_2D, 0L);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_3D, 1L);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_2D_MULTISAMPLE, 2L);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_EXTERNAL_OES, 3L);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_BUFFER, 4L);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_POSITIVE_X, 5L);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_NEGATIVE_X, 6L);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_POSITIVE_Y, 7L);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, 8L);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_POSITIVE_Z, 9L);
            this.put(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, 10L);
        }
    };
    public static final long GL_TEXTURE_2D_ARRAY_SURFACE_BASE = 0x10000000L;
    public static final long GL_TEXTURE_2D_MULTISAMPLE_ARRAY_SURFACE_BASE = 0x20000000L;
    public static final long GL_TEXTURE_CUBE_MAP_ARRAY_SURFACE_BASE = 0x30000000L;

    public static int getNumMipMapLevels(long baseLevelWidth, long baseLevelHeight, @Nullable Long baseLevelDepth) {
        long width = Math.max(1L, baseLevelWidth);
        long height = Math.max(1L, baseLevelHeight);
        long depth = Math.max(1L, baseLevelDepth != null ? baseLevelDepth : 1L);
        long maxSize = Math.max(width, Math.max(height, depth));
        return (int)(Math.floor(Math.log(maxSize) / Math.log(2.0)) + 1.0);
    }

    public static boolean isTargetUsingDepthAsArrayIndex(@NonNull AbstractConstantOrAliasSpecExtended target) {
        return target.equals(KapiSpec.GLES.constants.GL_TEXTURE_2D_ARRAY) || target.equals(KapiSpec.GLES.constants.GL_TEXTURE_2D_MULTISAMPLE_ARRAY) || target.equals(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_ARRAY);
    }

    public static boolean isCubeMapTarget(@NonNull AbstractConstantOrAliasSpecExtended target) {
        return target.equals(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP) || target.equals(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_ARRAY);
    }

    public static @Nullable Long mapTargetAndDepthToSurfaceId(@NonNull AbstractConstantOrAliasSpecExtended target, @Nullable Integer arrayIndex) {
        Long surfaceId = MAP_TARGET_TO_SURFACE_ID.get(target);
        if (surfaceId != null) {
            return surfaceId;
        }
        if (target.equals(KapiSpec.GLES.constants.GL_TEXTURE_2D_ARRAY)) {
            assert (arrayIndex != null);
            return 0x10000000L + (arrayIndex.longValue() & 0xFFFFFFFL);
        }
        if (target.equals(KapiSpec.GLES.constants.GL_TEXTURE_2D_MULTISAMPLE_ARRAY)) {
            assert (arrayIndex != null);
            return 0x20000000L + (arrayIndex.longValue() & 0xFFFFFFFL);
        }
        if (target.equals(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_ARRAY)) {
            assert (arrayIndex != null);
            return 0x30000000L + (arrayIndex.longValue() & 0xFFFFFFFL);
        }
        assert (false) : "Unexpected texture surface target: " + target;
        return null;
    }

    public static int getDepthFromSurfaceId(@NonNull AbstractConstantOrAliasSpecExtended target, long surfaceId) {
        Long fixedSurfaceId = MAP_TARGET_TO_SURFACE_ID.get(target);
        if (fixedSurfaceId != null) {
            return 0;
        }
        if (target.equals(KapiSpec.GLES.constants.GL_TEXTURE_2D_ARRAY)) {
            assert (surfaceId >= 0x10000000L);
            return Long.valueOf(surfaceId - 0x10000000L).intValue();
        }
        if (target.equals(KapiSpec.GLES.constants.GL_TEXTURE_2D_MULTISAMPLE_ARRAY)) {
            assert (surfaceId >= 0x20000000L);
            return Long.valueOf(surfaceId - 0x20000000L).intValue();
        }
        if (target.equals(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_ARRAY)) {
            assert (surfaceId >= 0x30000000L);
            return Long.valueOf(surfaceId - 0x30000000L).intValue();
        }
        assert (false) : "Unexpected texture surface target: " + target;
        return 0;
    }
}

