/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.utils.NullUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StringUtils {
    public static @NonNull String formatQuantity(long quantity, @NonNull String singularForm, @NonNull String pluralForm) {
        return quantity == 1L ? singularForm : pluralForm;
    }

    public static @NonNull String formatQuantity(@NonNull Number quantity, @NonNull String singularForm, @NonNull String pluralForm) {
        return quantity.doubleValue() == 1.0 ? singularForm : pluralForm;
    }

    public static @NonNull String arrayToString(Object[] items) {
        return StringUtils.arrayToString(items, -1);
    }

    public static @NonNull String listToString(List<?> items) {
        return StringUtils.listToString(items, -1);
    }

    public static @NonNull String arrayToString(Object[] items, int limit) {
        return StringUtils.listToString(items != null ? Arrays.asList(items) : null, limit);
    }

    public static @NonNull String listToString(List<?> items, int limit) {
        if (items == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int n = 0;
        for (Object item : items) {
            if (limit >= 0 && n >= limit) {
                sb.append("...");
                break;
            }
            if (n > 0) {
                sb.append(", ");
            }
            sb.append(item);
            ++n;
        }
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    public static String limitString(String text) {
        int delta;
        String[] parts = text.trim().split("[\r\n]", 2);
        String truncatedMark = "";
        if (parts.length > 1) {
            text = parts[0];
            truncatedMark = "...";
        }
        if ((delta = text.length() - 50) > 0) {
            text = text.substring(0, 50);
            truncatedMark = "...";
        }
        return String.valueOf(text.trim()) + truncatedMark;
    }

    public static String toHexString(long value, int length, char padding) {
        String hexString = Long.toHexString(value);
        return String.valueOf(StringUtils.fillString(padding, Math.max(0, length - hexString.length()))) + hexString;
    }

    public static String fillString(char chr, int length) {
        char[] chars = new char[length];
        Arrays.fill(chars, chr);
        return String.copyValueOf(chars);
    }

    public static @NonNull String commaSeparatedHexValues(Collection<Long> collection) {
        if (collection.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Long> it = collection.iterator();
        sb.append("0x");
        sb.append(Long.toHexString(it.next()));
        while (it.hasNext()) {
            sb.append(", 0x");
            sb.append(Long.toHexString(it.next()));
        }
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    public static @NonNull String commaSeparatedByteArrayHexFormat(boolean lineSeparated, int bytesPerLine, byte @NonNull [] array) {
        if (lineSeparated) assert (bytesPerLine > 0) : "Cannot format byte array into String: bytesPerLine must be greater than 0.";
        StringBuilder sb = new StringBuilder();
        int bytesSoFar = 0;
        int i = 0;
        while (i < array.length) {
            ++bytesSoFar;
            sb.append(String.format("%02X ", array[i]));
            if (i == array.length - 1) break;
            if (lineSeparated && bytesSoFar == bytesPerLine) {
                sb.append(System.lineSeparator());
                bytesSoFar = 0;
            } else {
                sb.append(", ");
            }
            ++i;
        }
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    public static @Nullable String formatUnixPermissionsIntoOctal(@NonNull String permissions) {
        char[] chars = permissions.toCharArray();
        StringBuilder builder = new StringBuilder("");
        if (chars.length != 9) {
            return null;
        }
        int charIndex = 0;
        int nextDigitBorder = 3;
        int outputIndex = 0;
        while (outputIndex < 3) {
            int currentDigit = 0;
            int i = charIndex;
            while (i < nextDigitBorder) {
                switch (chars[i]) {
                    case '-': {
                        break;
                    }
                    case 'r': {
                        currentDigit += 4;
                        break;
                    }
                    case 'w': {
                        currentDigit += 2;
                        break;
                    }
                    case 'x': {
                        ++currentDigit;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                ++i;
            }
            builder.append(Integer.toString(currentDigit));
            currentDigit = 0;
            charIndex += 3;
            nextDigitBorder += 3;
            ++outputIndex;
        }
        return builder.toString();
    }
}

