/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.util.IStatisticType;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.utils.NullUtils;
import java.text.DecimalFormat;
import org.eclipse.jdt.annotation.NonNull;

public class Statistic {
    private final @NonNull IStatisticType type;
    private final @NonNull Number value;
    private static final @NonNull DecimalFormat decimalFormat = new DecimalFormat("0.######");

    private Statistic(@NonNull IStatisticType type, @NonNull Number value) {
        this.type = type;
        this.value = value;
    }

    public Statistic(@NonNull IStatisticType type, long value) {
        this(type, NullUtils.longValueOf((long)value));
        assert (type.getNumberType() == IStatisticType.NumberType.LONG);
    }

    public Statistic(@NonNull IStatisticType type, double value) {
        this(type, NullUtils.doubleValueOf((double)value));
        assert (type.getNumberType() == IStatisticType.NumberType.DOUBLE);
    }

    public @NonNull Number getValue() {
        return this.value;
    }

    public String getValueString() {
        return String.valueOf(this.getFormattedValue()) + " " + StringUtils.formatQuantity(this.value, this.type.getUnitName(), this.type.getPluralUnitName());
    }

    public synchronized String getFormattedValue() {
        return decimalFormat.format(this.value);
    }
}

