/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.utils.NullUtils;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.NonNull;

public final class ReadOnlySubList<T>
implements List<T> {
    private final int fromIndex;
    private final @NonNull List<T> parentList;
    private final int toIndex;

    public ReadOnlySubList(@NonNull List<T> parentList) {
        this(parentList, 0, parentList.size());
    }

    public ReadOnlySubList(@NonNull List<T> parentList, int fromIndex, int toIndex) {
        this.parentList = parentList;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException("toIndex < fromIndex");
        }
        if (fromIndex < 0) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        if (toIndex > parentList.size()) {
            throw new IllegalArgumentException("toIndex > size()");
        }
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        for (T that : this) {
            if (!(o != null ? o.equals(that) : that == null)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object that : c) {
            if (this.contains(that)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof List) {
            List that = (List)obj;
            if (that.size() != this.size()) {
                return false;
            }
            int i = 0;
            while (i < this.size()) {
                if (!NullUtils.equals(this.get(i), that.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public T get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            return this.parentList.get(this.fromIndex + index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ConcurrentModificationException(e);
        }
    }

    @Override
    public int hashCode() {
        return this.parentList.hashCode() ^ this.fromIndex ^ this.toIndex * 17;
    }

    @Override
    public int indexOf(Object o) {
        int sz = this.size();
        int i = 0;
        while (i < sz) {
            T that = this.get(i);
            if (o != null ? o.equals(that) : that == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.fromIndex == this.toIndex;
    }

    @Override
    public @NonNull Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ReadOnlySubList.this.size();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return ReadOnlySubList.this.get(this.index++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public int lastIndexOf(Object o) {
        int sz = this.size();
        int i = sz - 1;
        while (i >= 0) {
            T that = this.get(i);
            if (o != null ? o.equals(that) : that == null) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(int start) {
        return new ListIterator<T>(start){
            private int index;
            {
                this.index = n;
            }

            @Override
            public void add(T e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.index < ReadOnlySubList.this.size();
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return ReadOnlySubList.this.get(this.index++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.index + 1 < ReadOnlySubList.this.size() ? this.index + 1 : ReadOnlySubList.this.size();
            }

            @Override
            public T previous() {
                if (this.hasPrevious()) {
                    return ReadOnlySubList.this.get(--this.index);
                }
                throw new NoSuchElementException();
            }

            @Override
            public int previousIndex() {
                return this.index - 1 >= 0 ? this.index - 1 : -1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(T e) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.toIndex - this.fromIndex;
    }

    @Override
    public List<T> subList(int childFromIndex, int childToIndex) {
        if (childToIndex < childFromIndex) {
            throw new IllegalArgumentException("toIndex < fromIndex");
        }
        if (childFromIndex < 0) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        if (childToIndex > this.size()) {
            throw new IllegalArgumentException("toIndex > size()");
        }
        return new ReadOnlySubList<T>(this.parentList, childFromIndex + this.fromIndex, childToIndex + this.fromIndex);
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.get(i);
            ++i;
        }
        return result;
    }

    @Override
    public <U> U[] toArray(U[] a) {
        int sz = this.size();
        Class<?> clazz = a.getClass();
        if (a.length < sz) {
            a = (Object[])Array.newInstance(clazz.getComponentType(), sz);
        }
        int i = 0;
        while (i < a.length) {
            a[i] = i < sz ? this.get(i) : null;
            ++i;
        }
        return a;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        int i = 0;
        while (i < this.size()) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.get(i));
            ++i;
        }
        result.append("]");
        return result.toString();
    }
}

