/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.utils.NullUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;

public final class ProcessRunner {
    private final int exitCode;
    private ProcessStreamReaderThread stdoutReader;
    private ProcessStreamReaderThread stderrReader;

    public ProcessRunner(String[] cmdarray, String[] envp, File dir) throws InterruptedException, IOException {
        this(cmdarray, envp, dir, 0, TimeUnit.SECONDS);
    }

    public ProcessRunner(String[] cmdarray, String[] envp, File dir, int timeout, TimeUnit unit) throws InterruptedException, IOException {
        Process process = null;
        BufferedReader stdout = null;
        BufferedReader stderr = null;
        try {
            process = Runtime.getRuntime().exec(cmdarray, envp, dir);
            stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
            stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            this.stdoutReader = new ProcessStreamReaderThread(stdout);
            this.stderrReader = new ProcessStreamReaderThread(stderr);
            this.stdoutReader.start();
            this.stderrReader.start();
            if (timeout > 0) {
                if (!process.waitFor(timeout, unit)) {
                    process.destroy();
                    throw new InterruptedException("Timed out");
                }
            } else {
                process.waitFor();
            }
            this.stdoutReader.join();
            this.stderrReader.join();
            this.exitCode = process.exitValue();
        }
        finally {
            block22: {
                try {
                    try {
                        if (stderr != null) {
                            stderr.close();
                        }
                        if (stdout != null) {
                            stdout.close();
                        }
                        if (process != null) {
                            process.getOutputStream().close();
                        }
                    }
                    catch (IOException x) {
                        CoreLogging.severe(null, x, "Unable to close process");
                        if (process != null) {
                            process.destroy();
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    if (process != null) {
                        process.destroy();
                    }
                    throw throwable;
                }
                if (process != null) {
                    process.destroy();
                }
            }
        }
    }

    public ProcessRunner(String[] array) throws InterruptedException, IOException {
        this(array, null, null);
    }

    public ProcessRunner(String[] array, int timeout, TimeUnit unit) throws InterruptedException, IOException {
        this(array, null, null, timeout, unit);
    }

    public @NonNull String getStderr() {
        return this.stderrReader.getOutput();
    }

    public @NonNull String getStdout() {
        return this.stdoutReader.getOutput();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    class ProcessStreamReaderThread
    extends Thread {
        private final StringBuilder output;
        private final BufferedReader reader;

        public ProcessStreamReaderThread(BufferedReader reader) {
            super("ProcessStreamReaderThread");
            this.output = new StringBuilder();
            this.reader = reader;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    this.output.append(line).append('\n');
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private @NonNull String getOutput() {
            return (String)NullUtils.neverNull((Object)this.output.toString());
        }
    }
}

