/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;

public abstract class NumberValueConverter<T extends Number>
implements Serializable {
    public static final NumberValueConverter<Byte> BOOLEAN_BYTE_CONVERTER = new NumberValueConverter<Byte>(){
        private static final long serialVersionUID = 1L;

        @Override
        public @NonNull Byte convert(@NonNull Number n) {
            return (byte)(n.byteValue() != 0 ? 1 : 0);
        }

        @Override
        public @NonNull Byte zeroValue() {
            return BYTE_ZERO_VALUE;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return BOOLEAN_BYTE_CONVERTER;
        }
    };
    public static final NumberValueConverter<Byte> BYTE_CONVERTER = new NumberValueConverter<Byte>(){
        private static final long serialVersionUID = 1L;

        @Override
        public @NonNull Byte convert(@NonNull Number n) {
            return (Byte)(n instanceof Byte ? (Number)n : (Number)n.byteValue());
        }

        @Override
        public @NonNull Byte zeroValue() {
            return BYTE_ZERO_VALUE;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return BYTE_CONVERTER;
        }
    };
    public static final NumberValueConverter<Float> FLOAT_CONVERTER = new NumberValueConverter<Float>(){
        private static final long serialVersionUID = 1L;

        @Override
        public @NonNull Float convert(@NonNull Number n) {
            return (Float)(n instanceof Float ? (Number)n : (Number)Float.valueOf(n.floatValue()));
        }

        @Override
        public @NonNull Float zeroValue() {
            return FLOAT_ZERO_VALUE;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return FLOAT_CONVERTER;
        }
    };
    public static final NumberValueConverter<Double> DOUBLE_CONVERTER = new NumberValueConverter<Double>(){
        private static final long serialVersionUID = 1L;

        @Override
        public @NonNull Double convert(@NonNull Number n) {
            return (Double)(n instanceof Double ? (Number)n : (Number)n.doubleValue());
        }

        @Override
        public @NonNull Double zeroValue() {
            return DOUBLE_ZERO_VALUE;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return DOUBLE_CONVERTER;
        }
    };
    public static final NumberValueConverter<Integer> INT_CONVERTER = new NumberValueConverter<Integer>(){
        private static final long serialVersionUID = 1L;

        @Override
        public @NonNull Integer convert(@NonNull Number n) {
            return (Integer)(n instanceof Integer ? (Number)n : (Number)n.intValue());
        }

        @Override
        public @NonNull Integer zeroValue() {
            return INT_ZERO_VALUE;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return INT_CONVERTER;
        }
    };
    public static final NumberValueConverter<Long> LONG_CONVERTER = new NumberValueConverter<Long>(){
        private static final long serialVersionUID = 1L;

        @Override
        public @NonNull Long convert(@NonNull Number n) {
            return (Long)(n instanceof Long ? (Number)n : (Number)n.longValue());
        }

        @Override
        public @NonNull Long zeroValue() {
            return LONG_ZERO_VALUE;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return LONG_CONVERTER;
        }
    };
    public static final NumberValueConverter<Short> SHORT_CONVERTER = new NumberValueConverter<Short>(){
        private static final long serialVersionUID = 1L;

        @Override
        public @NonNull Short convert(@NonNull Number n) {
            return (Short)(n instanceof Short ? (Number)n : (Number)n.shortValue());
        }

        @Override
        public @NonNull Short zeroValue() {
            return SHORT_ZERO_VALUE;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return SHORT_CONVERTER;
        }
    };
    public static final NumberValueConverter<Short> UNSIGNED_BYTE_CONVERTER = new NumberValueConverter<Short>(){
        private static final long serialVersionUID = 1L;

        @Override
        public @NonNull Short convert(@NonNull Number n) {
            return (short)(n.byteValue() & 0xFF);
        }

        @Override
        public @NonNull Short zeroValue() {
            return SHORT_ZERO_VALUE;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return UNSIGNED_BYTE_CONVERTER;
        }
    };
    public static final NumberValueConverter<Long> UNSIGNED_INT_CONVERTER = new NumberValueConverter<Long>(){
        private static final long serialVersionUID = 1L;

        @Override
        public @NonNull Long convert(@NonNull Number n) {
            return n.intValue() & 0xFFFFFFFF;
        }

        @Override
        public @NonNull Long zeroValue() {
            return LONG_ZERO_VALUE;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return UNSIGNED_INT_CONVERTER;
        }
    };
    public static final NumberValueConverter<Integer> UNSIGNED_SHORT_CONVERTER = new NumberValueConverter<Integer>(){
        private static final long serialVersionUID = 1L;

        @Override
        public @NonNull Integer convert(@NonNull Number n) {
            return n.shortValue() & 0xFFFF;
        }

        @Override
        public @NonNull Integer zeroValue() {
            return INT_ZERO_VALUE;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return UNSIGNED_SHORT_CONVERTER;
        }
    };
    private static final long serialVersionUID = 1L;
    private static final Byte BYTE_ZERO_VALUE = 0;
    private static final Float FLOAT_ZERO_VALUE = Float.valueOf(0.0f);
    private static final Double DOUBLE_ZERO_VALUE = 0.0;
    private static final Integer INT_ZERO_VALUE = 0;
    private static final Long LONG_ZERO_VALUE = 0L;
    private static final Short SHORT_ZERO_VALUE = 0;

    public abstract @NonNull T convert(@NonNull Number var1);

    public abstract @NonNull T zeroValue();

    protected abstract Object readResolve() throws ObjectStreamException;
}

