/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.utils.NullUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class NumberUtils {
    public static final int BYTES_PER_FLOAT = 4;
    public static final int BYTES_PER_SHORT = 2;
    public static final int BYTES_PER_HALF_FLOAT = 2;
    public static final int BYTES_PER_INTEGER = 4;
    public static final int BYTES_PER_LONG = 8;
    static double frac16Power = Math.pow(2.0, -16.0);

    public static float @NonNull [] getFloatsFromBytes(byte @NonNull [] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer fb = bb.asFloatBuffer();
        float[] ff = new float[bytes.length / 4];
        fb.get(ff);
        return ff;
    }

    public static short @NonNull [] getShortsFromBytes(byte @NonNull [] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer sb = bb.asShortBuffer();
        short[] ss = new short[bytes.length / 2];
        sb.get(ss);
        return ss;
    }

    public static int @NonNull [] getIntegersFromBytes(byte @NonNull [] bytes) {
        return NumberUtils.getIntegersFromBytes(NullUtils.asReadOnlyByteBuffer((byte[])bytes));
    }

    public static int @NonNull [] getIntegersFromBytes(@NonNull IByteDataProvider bytes) {
        return NumberUtils.getIntegersFromBytes(bytes.getData());
    }

    private static int @NonNull [] getIntegersFromBytes(@NonNull ByteBuffer bytes) {
        bytes.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer ib = bytes.asIntBuffer();
        int[] ii = new int[bytes.remaining() / 4];
        ib.get(ii);
        return ii;
    }

    public static @NonNull Float @NonNull [] getFloatObjectsFromBytes(byte @NonNull [] bytes) {
        float[] fa = NumberUtils.getFloatsFromBytes(bytes);
        @NonNull Float @NonNull [] ff = new Float[fa.length];
        int i = 0;
        while (i < fa.length) {
            ff[i] = NullUtils.floatValueOf((float)fa[i]);
            ++i;
        }
        return ff;
    }

    static float halfFloatBitsToFloat(byte top, byte bottom) {
        int halfFloatBits = (top & 0xFF) << 8 | bottom & 0xFF;
        int mantissa = halfFloatBits & 0x3FF;
        int exponent = halfFloatBits & 0x7C00;
        if (exponent == 31744) {
            exponent = 261120;
        } else if (exponent != 0) {
            if (mantissa == 0 && (exponent += 114688) > 115712) {
                return Float.intBitsToFloat((halfFloatBits & 0x8000) << 16 | exponent << 13 | 0x3FF);
            }
        } else if (mantissa != 0) {
            exponent = 115712;
            do {
                exponent -= 1024;
            } while (((mantissa <<= 1) & 0x400) == 0);
            mantissa &= 0x3FF;
        }
        return Float.intBitsToFloat((halfFloatBits & 0x8000) << 16 | (exponent | mantissa) << 13);
    }

    public static @NonNull Float @NonNull [] getHalfFloatObjectsFromBytes(byte @NonNull [] bytes) {
        assert (bytes.length % 2 == 0);
        @NonNull Float @NonNull [] ff = new Float[bytes.length / 2];
        int offset = 0;
        int i = 0;
        while (offset < bytes.length) {
            ff[i] = NullUtils.floatValueOf((float)NumberUtils.halfFloatBitsToFloat(bytes[offset + 1], bytes[offset]));
            offset += 2;
            ++i;
        }
        return ff;
    }

    public static @NonNull Byte @NonNull [] getByteObjectsForBytesFromBytes(byte @NonNull [] bytes) {
        @NonNull Byte @NonNull [] ss = new Byte[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            ss[i] = NullUtils.byteValueOf((byte)bytes[i]);
            ++i;
        }
        return ss;
    }

    public static @NonNull Short @NonNull [] getShortObjectsForUnsignedBytesFromBytes(byte @NonNull [] bytes) {
        @NonNull Short @NonNull [] ll = new Short[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            ll[i] = NullUtils.shortValueOf((short)((short)(bytes[i] & 0xFF)));
            ++i;
        }
        return ll;
    }

    public static @NonNull Short @NonNull [] getShortObjectsForShortsFromBytes(byte @NonNull [] bytes) {
        short[] sa = NumberUtils.getShortsFromBytes(bytes);
        @NonNull Short @NonNull [] ll = new Short[sa.length];
        int i = 0;
        while (i < sa.length) {
            ll[i] = NullUtils.shortValueOf((short)sa[i]);
            ++i;
        }
        return ll;
    }

    public static @NonNull Integer @NonNull [] getIntegerObjectsForUnsignedShortsFromBytes(byte @NonNull [] bytes) {
        short[] sa = NumberUtils.getShortsFromBytes(bytes);
        @NonNull Integer @NonNull [] ll = new Integer[sa.length];
        int i = 0;
        while (i < sa.length) {
            ll[i] = NullUtils.intValueOf((int)(sa[i] & 0xFFFF));
            ++i;
        }
        return ll;
    }

    public static @NonNull Long @NonNull [] getLongObjectsForUnsignedIntsFromBytes(byte @NonNull [] bytes) {
        int[] sa = NumberUtils.getIntegersFromBytes(bytes);
        @NonNull Long @Nullable [] ll = new Long[sa.length];
        int i = 0;
        while (i < sa.length) {
            ll[i] = NullUtils.longValueOf((long)((long)sa[i] & 0xFFFFFFFFL));
            ++i;
        }
        return ll;
    }

    public static long @NonNull [] getLongsForInt64FromBytes(byte @NonNull [] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer ib = bb.asLongBuffer();
        long[] ll = new long[bytes.length / 8];
        ib.get(ll);
        return ll;
    }

    public static @NonNull Long @Nullable [] getLongObjectsForInt64FromBytes(byte @NonNull [] bytes) {
        long[] sa = NumberUtils.getLongsForInt64FromBytes(bytes);
        @NonNull Long @Nullable [] ll = new Long[sa.length];
        int i = 0;
        while (i < sa.length) {
            ll[i] = NullUtils.longValueOf((long)sa[i]);
            ++i;
        }
        return ll;
    }

    public static @NonNull Integer @NonNull [] getIntegerObjectsForIntegersFromBytes(byte @NonNull [] bytes) {
        int[] ia = NumberUtils.getIntegersFromBytes(bytes);
        @NonNull Integer @NonNull [] ii = new Integer[ia.length];
        int i = 0;
        while (i < ia.length) {
            ii[i] = NullUtils.intValueOf((int)ia[i]);
            ++i;
        }
        return ii;
    }

    public static @NonNull Double @NonNull [] getDoubleObjectsForFixedFromBytes(byte @NonNull [] bytes) {
        int[] ia = NumberUtils.getIntegersFromBytes(bytes);
        @NonNull Double @NonNull [] dd = new Double[ia.length];
        int i = 0;
        while (i < dd.length) {
            dd[i] = NullUtils.doubleValueOf((double)((double)ia[i] * frac16Power));
            ++i;
        }
        return dd;
    }

    public static float @NonNull [] toFloatArray(@NonNull Number @NonNull [] numbers) {
        float[] primitive = new float[numbers.length];
        int i = 0;
        while (i < numbers.length) {
            primitive[i] = numbers[i].floatValue();
            ++i;
        }
        return primitive;
    }

    public static long @NonNull [] toLongArray(@NonNull Number @NonNull [] numbers) {
        long[] primitive = new long[numbers.length];
        int i = 0;
        while (i < numbers.length) {
            primitive[i] = numbers[i].longValue();
            ++i;
        }
        return primitive;
    }

    public static short @NonNull [] toShortArray(@NonNull Number @NonNull [] numbers) {
        short[] primitive = new short[numbers.length];
        int i = 0;
        while (i < numbers.length) {
            primitive[i] = numbers[i].shortValue();
            ++i;
        }
        return primitive;
    }

    public static int @NonNull [] toIntArray(@NonNull Number @NonNull [] numbers) {
        int[] primitive = new int[numbers.length];
        int i = 0;
        while (i < numbers.length) {
            primitive[i] = numbers[i].intValue();
            ++i;
        }
        return primitive;
    }

    public static double @NonNull [] toDoubleArray(@NonNull Number @NonNull [] numbers) {
        double[] primitive = new double[numbers.length];
        int i = 0;
        while (i < numbers.length) {
            primitive[i] = numbers[i].doubleValue();
            ++i;
        }
        return primitive;
    }

    public static float decodeFloat(String s) {
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            if ("-inf".equals(s)) {
                return Float.NEGATIVE_INFINITY;
            }
            if ("inf".equals(s)) {
                return Float.POSITIVE_INFINITY;
            }
            if ("+inf".equals(s)) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NaN;
        }
    }

    public static double decodeDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            if ("-inf".equals(s)) {
                return Double.NEGATIVE_INFINITY;
            }
            if ("inf".equals(s)) {
                return Double.POSITIVE_INFINITY;
            }
            if ("+inf".equals(s)) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
    }

    public static @NonNull Integer decodeInt(@NonNull String s) {
        try {
            return (Integer)NullUtils.neverNull((Object)Integer.decode(s));
        }
        catch (NumberFormatException e) {
            if ("(nil)".equals(s)) {
                return NullUtils.intValueOf((int)0);
            }
            throw e;
        }
    }

    public static @NonNull Long decodeLong(@NonNull String s) {
        try {
            return (Long)NullUtils.neverNull((Object)Long.decode(s.replaceAll("[<>]", "")));
        }
        catch (NumberFormatException e) {
            if ("(nil)".equals(s)) {
                return NullUtils.longValueOf((long)0L);
            }
            throw e;
        }
    }

    public static @Nullable Number decodeNumber(@NonNull String s) {
        if (s.startsWith("0x")) {
            try {
                return Long.valueOf(s.substring(2), 16);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (s.startsWith("0")) {
            try {
                return Long.valueOf(s, 8);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        try {
            return Long.valueOf(s);
        }
        catch (NumberFormatException e) {
            try {
                return Float.valueOf(s);
            }
            catch (NumberFormatException e1) {
                return null;
            }
        }
    }

    public static boolean isFPNumber(@Nullable Object value) {
        return value != null && (value instanceof Float || value instanceof Double);
    }

    public static boolean isIntNumber(@Nullable Object value) {
        return value != null && (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long);
    }

    public static @NonNull Short @NonNull [] getShortObjectsForInt_2_10_10_10FromBytes(byte @NonNull [] bytes) {
        int[] ii = NumberUtils.getIntegersFromBytes(bytes);
        @NonNull Short @NonNull [] ss = new Short[bytes.length];
        int i = 0;
        int j = 0;
        while (i < ss.length) {
            short temp = (short)(ii[j] << 6 & 0xFFC0);
            ss[i] = NullUtils.shortValueOf((short)((short)(temp >>> 6)));
            temp = (short)(ii[j] >> 4 & 0xFFC0);
            ss[i + 1] = NullUtils.shortValueOf((short)((short)(temp >>> 6)));
            temp = (short)(ii[j] >> 14 & 0xFFC0);
            ss[i + 2] = NullUtils.shortValueOf((short)((short)(temp >>> 6)));
            temp = (short)(ii[j] >> 16 & 0xC000);
            ss[i + 3] = NullUtils.shortValueOf((short)((short)(temp >>> 14)));
            i += 4;
            ++j;
        }
        return ss;
    }

    public static @NonNull Short @NonNull [] getShortObjectsForUnsignedInt_2_10_10_10FromBytes(byte @NonNull [] bytes) {
        int[] ii = NumberUtils.getIntegersFromBytes(bytes);
        @NonNull Short @NonNull [] ss = new Short[bytes.length];
        int i = 0;
        int j = 0;
        while (i < ss.length) {
            ss[i] = NullUtils.shortValueOf((short)((short)(ii[j] & 0x3FF)));
            ss[i + 1] = NullUtils.shortValueOf((short)((short)(ii[j] >> 10 & 0x3FF)));
            ss[i + 2] = NullUtils.shortValueOf((short)((short)(ii[j] >> 20 & 0x3FF)));
            ss[i + 3] = NullUtils.shortValueOf((short)((short)(ii[j] >> 30 & 3)));
            i += 4;
            ++j;
        }
        return ss;
    }

    public static int @NonNull [] getIntSortedArray(int start, int length) {
        assert (length >= 0);
        assert (start >= 0);
        int[] newArray = new int[length];
        int i = 0;
        while (i < length) {
            newArray[i] = start + i;
            ++i;
        }
        return newArray;
    }

    public static int @NonNull [] sortIntArrayAndRemoveDuplicates(int @NonNull [] array) {
        if (array.length == 0) {
            return array;
        }
        Arrays.sort(array);
        int lastValue = array[0] - 1;
        int numUniqueElements = 0;
        int i = 0;
        while (i < array.length) {
            int value = array[i];
            if (lastValue != value) {
                array[numUniqueElements] = value;
                lastValue = value;
                ++numUniqueElements;
            }
            ++i;
        }
        return NullUtils.neverNull((int[])Arrays.copyOf(array, numUniqueElements));
    }

    public static long intToUnsignedLong(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    public static @NonNull Long intToBoxedUnsignedLong(int i) {
        return NullUtils.longValueOf((long)((long)i & 0xFFFFFFFFL));
    }

    public static @NonNull Long valueOfLongDecimalOrHex(@NonNull String text) {
        if (text.matches("^[+\\-]?0x[0-9A-Fa-f]+l?$")) {
            return (Long)NullUtils.neverNull((Object)Long.valueOf(text.substring(2), 16));
        }
        if (text.matches("^[+\\-]?0[0-7]*l?$")) {
            return (Long)NullUtils.neverNull((Object)Long.valueOf(text, 8));
        }
        return (Long)NullUtils.neverNull((Object)Long.valueOf(text, 10));
    }
}

