/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.IMemoryListener;
import com.arm.mgd.core.util.ListenerList;

public class MemoryMonitor
extends Thread {
    public static final String CRITICAL_MEMORY_USER_MESSAGE = "JVM available memory is critically low. This can lead to performance issues or errors. Please consider increasing the maximum heap size and restarting the application." + System.lineSeparator() + System.lineSeparator() + "The heap size can be configured by appending a flag to the aga.ini file in the GA install directory. " + "On a new line, add '-Xmx' followed by your desired heap size. For example, -Xmx8g sets the maximum heap size to 8GB." + System.lineSeparator() + System.lineSeparator() + "Please make sure that the size of total JVM memory is less than the size of available physical memory (RAM), otherwise this will lead to unpredictable performance issues. " + "Bear in mind that the JVM uses more memory than just the heap, so the actual memory footprint of the JVM will be larger than the maximum heap size.";
    private static final long MONITOR_DELAY_MS = 1000L;
    public static final long MB = 0x100000L;
    private boolean isMonitoring = true;
    public static final long warningLevel = 0x6400000L;
    public static final long criticalLevel = 0x3200000L;
    private final ListenerList<IMemoryListener> listeners = new ListenerList();
    private static MemoryMonitor INSTANCE;

    public static synchronized MemoryMonitor getInstance() {
        if (INSTANCE == null) {
            MemoryMonitor temp = new MemoryMonitor();
            temp.start();
            INSTANCE = temp;
        }
        return INSTANCE;
    }

    protected MemoryMonitor() {
        super("Memory monitor");
        this.setDaemon(true);
    }

    public void addListener(IMemoryListener listenerToAdd) {
        this.listeners.add(listenerToAdd);
    }

    @Override
    public void run() {
        boolean warningReported = false;
        boolean criticalReported = false;
        while (this.isMonitoring) {
            long availableMemory = this.getAvailableMemory();
            if (availableMemory <= 0x3200000L) {
                CoreLogging.warning(null, "Critical low memory level detected, invoking gc.");
                System.gc();
                availableMemory = this.getAvailableMemory();
                if (availableMemory <= 0x3200000L && !criticalReported) {
                    for (IMemoryListener listener : this.listeners) {
                        listener.onMemoryBelowCriticalLevel((int)(availableMemory / 0x100000L));
                    }
                    criticalReported = true;
                }
            } else if (availableMemory <= 0x6400000L) {
                CoreLogging.warning(null, "Low memory level detected, invoking gc.");
                System.gc();
                availableMemory = this.getAvailableMemory();
                if (availableMemory <= 0x6400000L && !warningReported) {
                    CoreLogging.info(null, "Low memory level still detected.");
                    for (IMemoryListener listener : this.listeners) {
                        listener.onMemoryBelowWarningLevel((int)(availableMemory / 0x100000L));
                    }
                    warningReported = true;
                }
            } else {
                criticalReported = false;
                warningReported = false;
            }
            try {
                MemoryMonitor.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void stopMonitoring() {
        this.isMonitoring = false;
        this.interrupt();
    }

    public void removeListener(IMemoryListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isMemoryAvailable(long expectedBytes) {
        return this.getAvailableMemory() - expectedBytes > 0x6400000L;
    }

    public long getAvailableMemory() {
        Runtime rt = Runtime.getRuntime();
        return rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
    }
}

