/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.ini.IniFile;
import com.arm.ini.IniFileParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class IniUtils {
    public static @NonNull Map<@NonNull String, @NonNull String> iniContentsAsMap(@NonNull InputStream stream) throws IOException {
        IniFile contents = IniFileParser.parse((InputStream)stream);
        @NonNull LinkedHashMap<@NonNull String, @NonNull String> keysAndValues = new LinkedHashMap<String, String>();
        for (IniFile.Section section : contents.sections()) {
            String prefix = section.name().isEmpty() ? "" : String.valueOf(section.name()) + ".";
            for (String key : section.keys()) {
                String propertyValue = section.property(key);
                keysAndValues.put(String.valueOf(prefix) + key, propertyValue == null ? "" : propertyValue);
            }
        }
        return keysAndValues;
    }
}

