/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.GlShaderHelper;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import com.arm.mgd.core.util.IAssetsCollectionGetter;
import com.arm.mgd.utils.NullUtils;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;

@FunctionalInterface
public interface IGlShaderAssetGetter
extends IAssetsCollectionGetter<GlShaderAsset> {
    public static @NonNull IGlShaderAssetGetter getAllShadersAtFunctionCall(@NonNull TraceDataModel model, int functionIndex) {
        return () -> {
            SynchronousTraceStateSnapshot snapshot = new SynchronousTraceStateSnapshot(model);
            snapshot.setSelectedFunction(functionIndex);
            return GlShaderHelper.getAllLivingShaders(snapshot);
        };
    }

    public static @NonNull IGlShaderAssetGetter getSpecificShadersAtFunctionCall(@NonNull TraceDataModel model, @NonNull Set<@NonNull Long> shaderIDs, int functionIndex) {
        return () -> {
            SynchronousTraceStateSnapshot snapshot = new SynchronousTraceStateSnapshot(model);
            snapshot.setSelectedFunction(functionIndex);
            if (shaderIDs.isEmpty()) {
                return GlShaderHelper.getAllLivingShaders(snapshot);
            }
            return NullUtils.collectToList((Stream)NullUtils.filteredStream(GlShaderHelper.getAllLivingShaders(snapshot), shader -> shaderIDs.contains(shader.getId())));
        };
    }

    public static @NonNull IGlShaderAssetGetter getAllShadersAtFrame(@NonNull TraceDataModel model, int frameIndex) {
        return () -> {
            SynchronousTraceStateSnapshot snapshot = new SynchronousTraceStateSnapshot(model);
            snapshot.setSelectedFunction(model.getFrames().getFrameAt(frameIndex).getLastFunctionIndex());
            return GlShaderHelper.getAllLivingShaders(snapshot);
        };
    }

    public static @NonNull IGlShaderAssetGetter getSpecificShadersAtFrame(@NonNull TraceDataModel model, @NonNull Set<@NonNull Long> shaderIDs, int frameIndex) {
        return () -> {
            SynchronousTraceStateSnapshot snapshot = new SynchronousTraceStateSnapshot(model);
            snapshot.setSelectedFunction(model.getFrames().getFrameAt(frameIndex).getLastFunctionIndex());
            if (shaderIDs.isEmpty()) {
                return GlShaderHelper.getAllLivingShaders(snapshot);
            }
            return NullUtils.collectToList((Stream)NullUtils.filteredStream(GlShaderHelper.getAllLivingShaders(snapshot), shader -> shaderIDs.contains(shader.getId())));
        };
    }
}

