/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;

@FunctionalInterface
public interface IAssetsCollectionGetter<T extends @NonNull IAssetItem> {
    public @NonNull Collection<T> get();

    public static <S extends IAssetItem> @NonNull IAssetsCollectionGetter<S> getAssetsAtFrame(@NonNull TraceDataModel model, int frameNo, @NonNull AssetTableSpec assetTableSpec, @NonNull Predicate<S> pred) {
        return IAssetsCollectionGetter.getAssetsAtFunctionCall(model, model.getFrames().getFrameAt(frameNo).getLastFunctionIndex(), assetTableSpec, pred);
    }

    public static <S extends IAssetItem> @NonNull IAssetsCollectionGetter<S> getAssetsAtFunctionCall(@NonNull TraceDataModel model, int functionIndex, @NonNull AssetTableSpec assetTableSpec, @NonNull Predicate<S> pred) {
        return () -> {
            SynchronousTraceStateSnapshot traceStateSnapshot = new SynchronousTraceStateSnapshot(model);
            traceStateSnapshot.setSelectedFunction(functionIndex);
            @NonNull IAssetItem[] elements = traceStateSnapshot.getAssetTableBySpec(assetTableSpec).toArray();
            @NonNull List<@NonNull T> collectedAssets = Stream.of(elements).map(asset -> asset).filter(pred).collect(Collectors.toList());
            return collectedAssets;
        };
    }
}

