/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.math.BigInteger;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class HashUtils {
    private static final int RADIX = Math.min(36, 36);

    public static byte @Nullable [] getMD5Hash(@NonNull File file) {
        byte[] fileBytes;
        try {
            fileBytes = Files.readAllBytes(file.toPath().toAbsolutePath());
        }
        catch (Throwable t) {
            return null;
        }
        return HashUtils.getMD5Hash(NullUtils.neverNull((byte[])fileBytes));
    }

    public static byte @NonNull [] getMD5Hash(byte @NonNull [] bytes) {
        MessageDigest md5Hasher = null;
        try {
            md5Hasher = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        return NullUtils.neverNull((byte[])md5Hasher.digest(bytes));
    }

    public static byte @NonNull [] getMD5Hash(@NonNull IByteDataProvider bytes) {
        MessageDigest md5Hasher = null;
        try {
            md5Hasher = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        md5Hasher.update(bytes.getData());
        return NullUtils.neverNull((byte[])md5Hasher.digest());
    }

    public static @NonNull String getBytesAsString(byte @NonNull [] bytes) {
        return (String)NullUtils.neverNull((Object)new BigInteger(1, bytes).toString(RADIX));
    }
}

