/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.asset.ComputeWorkgroupSize;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.FileUtils;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.jdt.annotation.NonNull;

public class GpuVerify {
    public static void launchGpuVerify(@NonNull Long clKernelId, @NonNull String gpuVerifyLocation, @NonNull GpuVerifyCommand command) throws IOException {
        String line;
        File jsonFile = FileUtils.createTempFile(clKernelId.toString(), ".json");
        BufferedWriter jsonBufferWriter = new BufferedWriter(new FileWriter(jsonFile));
        Gson jsonBuilder = new Gson();
        GpuVerifyCommand[] commandArray = new GpuVerifyCommand[]{command};
        String jsonToWrite = jsonBuilder.toJson((Object)commandArray);
        jsonBufferWriter.write(jsonToWrite);
        jsonBufferWriter.close();
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(new String[]{gpuVerifyLocation, "--json", jsonFile.getAbsolutePath()});
        BufferedReader outStream = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        BufferedReader errorStream = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        while ((line = outStream.readLine()) != null) {
            CoreLogging.info(null, line);
        }
        while ((line = errorStream.readLine()) != null) {
            CoreLogging.info(null, line);
        }
    }

    public static class GpuVerifyCommand {
        private final String language;
        private final String kernel_file;
        private final long[] local_size;
        private final long[] global_size;
        private final String entry_point;
        private final String compiler_flags;

        public GpuVerifyCommand(@NonNull String kernelFile, @NonNull ComputeWorkgroupSize localSize, @NonNull ComputeWorkgroupSize globalSize, @NonNull String entryPoint, @NonNull String compilerFlags) {
            this.language = "OpenCL";
            this.kernel_file = kernelFile;
            assert (localSize.getNumDimensions() == globalSize.getNumDimensions());
            this.local_size = localSize.asLongArray();
            this.global_size = globalSize.asLongArray();
            this.entry_point = entryPoint;
            this.compiler_flags = compilerFlags;
        }
    }
}

