/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.SearchListener;
import com.arm.mgd.core.util.executors.NamedSingleThreadExecutor;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionCallSearcher {
    private final @NonNull NamedSingleThreadExecutor searchExecutor = new NamedSingleThreadExecutor("FunctionCallSearch.SearchThread", true);
    private final @NonNull AtomicReference<@Nullable SearchResults> lastSearchResults = new AtomicReference<Object>(null);
    private final @NonNull AtomicReference<@Nullable SearchJob> currentJob = new AtomicReference<Object>(null);
    private @Nullable SearchParameters nextParameters = null;
    private final @NonNull SearchListener listener;

    public FunctionCallSearcher(@NonNull SearchListener listener) {
        this.listener = listener;
    }

    public synchronized void searchFor(@NonNull SearchParameters parameters) {
        this.nextParameters = parameters;
        SearchJob job = this.currentJob.get();
        if (job == null) {
            this.enqueueNextJob();
        } else if (!job.parameters.equals(parameters)) {
            job.cancelled.set(true);
        }
    }

    private synchronized void enqueueNextJob() {
        this.currentJob.set(null);
        @Nullable SearchParameters parameters = this.nextParameters;
        this.nextParameters = null;
        if (parameters != null) {
            SearchResults lastResults = this.lastSearchResults.get();
            SearchJob newJob = new SearchJob(parameters);
            if (lastResults == null || !lastResults.parameters.equals(parameters) || lastResults.toIndex != newJob.toIndex) {
                this.currentJob.set(newJob);
                this.searchExecutor.runLater(() -> {
                    @Nullable SearchResults results = newJob.doSearch(lastResults);
                    if (results != null) {
                        this.listener.searchItemsFound(results);
                    }
                    this.lastSearchResults.set(results);
                    this.enqueueNextJob();
                });
            }
        }
    }

    public double getCurrentSearchProgress() {
        SearchJob job = this.currentJob.get();
        if (job != null) {
            return job.getProgress();
        }
        SearchResults results = this.lastSearchResults.get();
        if (results != null) {
            return 1.0;
        }
        return -1.0;
    }

    public synchronized void terminate() {
        SearchJob job = this.currentJob.get();
        if (job != null) {
            job.cancelled.set(true);
        }
        this.lastSearchResults.set(null);
        this.currentJob.set(null);
        this.nextParameters = null;
        this.searchExecutor.shutdownNow();
    }

    private static class SearchJob {
        private final @NonNull SearchParameters parameters;
        private final int toIndex;
        private final @NonNull AtomicBoolean cancelled = new AtomicBoolean(false);
        private final @NonNull AtomicInteger progress = new AtomicInteger(0);

        private SearchJob(@NonNull SearchParameters parameters) {
            this.parameters = parameters;
            this.toIndex = parameters.model.count();
        }

        private double getProgress() {
            if (this.cancelled.get()) {
                return -1.0;
            }
            if (this.toIndex == 0) {
                return 1.0;
            }
            return Math.min(1.0, Math.max(0.0, (double)this.progress.get() / (double)this.toIndex));
        }

        private @Nullable SearchResults doSearch(@Nullable SearchResults priorResults) {
            List<Integer> results;
            assert (this.progress.get() == 0);
            @NonNull ICoreProgressMonitor monitor = new ICoreProgressMonitor(){

                @Override
                public void setTask(String name, int totalWork) {
                }

                @Override
                public boolean isCancelled() {
                    return cancelled.get();
                }

                @Override
                public void incProgress(int n) {
                    progress.addAndGet(n);
                }
            };
            if (priorResults != null && priorResults.parameters.equals(this.parameters)) {
                monitor.incProgress(priorResults.toIndex);
                results = new ArrayList<Integer>(priorResults.results);
                results.addAll(this.parameters.model.findContaining(this.parameters.searchPattern, priorResults.toIndex, this.toIndex, monitor, this.parameters.includeParameters));
            } else {
                results = this.parameters.model.findContaining(this.parameters.searchPattern, 0, this.toIndex, monitor, this.parameters.includeParameters);
            }
            if (monitor.isCancelled()) {
                return null;
            }
            return new SearchResults(this.parameters, this.toIndex, results);
        }
    }

    public static class SearchParameters {
        public final @NonNull Pattern searchPattern;
        public final @NonNull TraceDataModel model;
        public final boolean includeParameters;

        public SearchParameters(@NonNull Pattern searchPattern, @NonNull TraceDataModel model, boolean includeParameters) {
            this.searchPattern = searchPattern;
            this.model = model;
            this.includeParameters = includeParameters;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SearchParameters) {
                SearchParameters other = (SearchParameters)obj;
                return Objects.equals(this.searchPattern, other.searchPattern) && this.model.equals(other.model) && this.includeParameters == other.includeParameters;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.searchPattern, this.model, this.includeParameters);
        }
    }

    public static class SearchResults {
        public final @NonNull SearchParameters parameters;
        public final int toIndex;
        public final @NonNull List<@NonNull Integer> results;

        private SearchResults(@NonNull SearchParameters searchParameters, int toIndex, @NonNull List<@NonNull Integer> results) {
            this.parameters = searchParameters;
            this.toIndex = toIndex;
            this.results = NullUtils.unmodifiableList(results);
        }
    }
}

