/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.VersionProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FileUtils {
    private static @NonNull File temporaryDirectory = FileUtils.createMGDTemporaryDirectory(null);
    private static final @NonNull ExecutorService EXECUTOR = NamedExecutors.cachedNumCoresThreadPool(60L, TimeUnit.SECONDS, new NamedThreadFactory("FileUtils Executor", 5));

    public static void deleteFileInBackground(final File file) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                file.delete();
            }

            public String toString() {
                return "deleting-file-" + file;
            }
        };
        EXECUTOR.execute(r);
    }

    public static void setTemporaryDirectoryRoot(@Nullable String newTempDirPath) {
        temporaryDirectory = FileUtils.createMGDTemporaryDirectory(newTempDirPath);
    }

    private static @NonNull File createMGDTemporaryDirectory(@Nullable String newRootTempDirPath) {
        if (newRootTempDirPath == null) {
            newRootTempDirPath = System.getProperty("java.io.tmpdir");
        }
        File rootTemporaryDirectory = new File(newRootTempDirPath);
        File appTempDir = null;
        String appTempSubdir = VersionProperties.SHORT_PRODUCT_NAME.toLowerCase().replaceAll("[^a-z0-9. -]", "_");
        try {
            appTempDir = Files.createTempDirectory(rootTemporaryDirectory.toPath(), appTempSubdir, new FileAttribute[0]).toFile();
            appTempDir.deleteOnExit();
        }
        catch (IOException e) {
            CoreLogging.severe(null, "Unable to create temporary directory \"" + appTempSubdir + "\" in \"" + newRootTempDirPath + "\"");
        }
        if (appTempDir == null) {
            appTempDir = rootTemporaryDirectory;
        }
        assert (appTempDir != null);
        assert (appTempDir.isDirectory());
        return appTempDir;
    }

    public static @NonNull File getTemporaryDirectory() {
        return temporaryDirectory;
    }

    public static @NonNull File createTempFile(String prefix, String suffix) throws IOException {
        File tempFile = Files.createTempFile(temporaryDirectory.toPath(), prefix, suffix, new FileAttribute[0]).toFile();
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static @NonNull File getFileInTempDir(String name) {
        File f = new File(temporaryDirectory, name);
        f.deleteOnExit();
        return f;
    }

    public static @NonNull File makeFileFromBuffers(String prefix, String suffix, byte[] ... datas) throws IOException {
        @NonNull ByteBuffer @NonNull [] buffers = new ByteBuffer[datas.length];
        int i = 0;
        while (i < datas.length) {
            buffers[i] = NullUtils.asReadOnlyByteBuffer((byte[])datas[i]);
            ++i;
        }
        return FileUtils.makeFileFromBuffers(prefix, suffix, buffers);
    }

    public static @NonNull File makeFileFromBuffers(String prefix, String suffix, ByteBuffer ... datas) throws IOException {
        File tempFile = FileUtils.createTempFile(prefix, suffix);
        FileOutputStream outputStream = null;
        FileChannel channel = null;
        try {
            outputStream = new FileOutputStream(tempFile);
            channel = outputStream.getChannel();
            channel.write(datas);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (channel != null) {
                channel.close();
            }
        }
        return tempFile;
    }

    public static boolean blockingRead(InputStream inputStream, byte[] buffer) throws IOException {
        int bytesRead = 0;
        int messageLength = buffer.length;
        while (bytesRead < messageLength) {
            int currentBytesRead = inputStream.read(buffer, bytesRead, messageLength - bytesRead);
            if (currentBytesRead == -1) {
                Arrays.fill(buffer, (byte)0);
                return false;
            }
            assert ((bytesRead += currentBytesRead) <= messageLength);
        }
        return true;
    }
}

