/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.util.IUserFileStore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DirectoryUserFileStore
implements IUserFileStore {
    private final File directory;

    public DirectoryUserFileStore(@NonNull File directory) {
        this.directory = directory;
    }

    @Override
    public void store(@NonNull Path path, byte @NonNull [] data) throws IOException {
        Path newPath = this.directory.toPath().resolve(path);
        if (newPath.toFile().exists() || newPath.toFile().createNewFile()) {
            FileOutputStream fw = new FileOutputStream(newPath.toFile());
            fw.write(data);
            fw.close();
        }
    }

    @Override
    public byte @Nullable [] load(@NonNull Path path) throws IOException {
        Path newPath = this.directory.toPath().resolve(path);
        if (newPath.toFile().exists()) {
            return Files.readAllBytes(newPath);
        }
        return null;
    }
}

