/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;

public class Dimension
implements Comparable<Dimension>,
Serializable {
    private static final long serialVersionUID = -1146913614594984015L;
    public static final @NonNull Dimension ZERO = new Dimension(0, 0, 0);
    private final int width;
    private final int height;
    private final int depth;
    private final int volume;
    private final boolean is2D;

    public Dimension(int width, int height) {
        this(true, width, height, 1);
    }

    public Dimension(int width, int height, int depth) {
        this(false, width, height, depth);
    }

    private Dimension(boolean is2D, int width, int height, int depth) {
        this.is2D = is2D;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.volume = width * height * depth;
    }

    @Override
    public int compareTo(Dimension other) {
        if (other == null) {
            return 1;
        }
        int result = this.volume - other.volume;
        if (result == 0) {
            result = this.width - other.width;
        }
        if (result == 0) {
            result = this.height - other.height;
        }
        return result;
    }

    public boolean isValid() {
        return this.width > 0 && this.height > 0 && this.depth > 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        result = 31 * result + this.depth;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Dimension) {
            Dimension other = (Dimension)obj;
            return this.height == other.height && this.width == other.width && this.depth == other.depth;
        }
        return false;
    }

    public @NonNull String toString() {
        String returnString = String.valueOf(this.width) + " x " + this.height;
        if (!this.is2D) {
            returnString = String.valueOf(returnString) + " x " + this.depth;
        }
        return returnString;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getArea() {
        assert (this.is2D) : "Trying to get the area of a 3D dimension, make sure 3D dimensions are dealt with and use getVolume() instead.";
        return this.volume;
    }

    public int getVolume() {
        assert (!this.is2D) : "Trying to get the volume of a 2D dimension, use getArea() instead.";
        return this.volume;
    }

    public boolean is2D() {
        return this.is2D;
    }
}

