/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.core.util.LoggerListener;
import com.arm.mgd.utils.NullUtils;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CoreLogging {
    public static final String USER_MESSAGE_LOGGER_NAME = "com.arm.mgd.core.util.corelogging.usermessagelogger";
    private static final Set<String> messagesToBeReportedOnce = new TreeSet<String>();
    private static @NonNull HashMap<String, Logger> loggers = new HashMap();
    private static @Nullable LoggerListener loggerListener;
    private static @NonNull Logger globalLogger;

    static {
        globalLogger = (Logger)NullUtils.neverNull((Object)Logger.getLogger("global"));
    }

    public static void addLoggerListener(@NonNull LoggerListener listener) {
        loggerListener = listener;
    }

    static @NonNull Logger getLogger(@Nullable ICoreLoggingSource source) {
        if (source == null) {
            return globalLogger;
        }
        String loggingSourceKey = source.getCoreLoggingSourceKey();
        Logger logger = loggers.get(loggingSourceKey);
        if (logger == null) {
            logger = (Logger)NullUtils.neverNull((Object)Logger.getLogger(loggingSourceKey));
            loggers.put(loggingSourceKey, logger);
            if (loggerListener != null) {
                loggerListener.onLoggerAdded(logger);
            }
        }
        return logger;
    }

    public static void info(@Nullable ICoreLoggingSource source, @NonNull Throwable throwable, @Nullable String msg) {
        CoreLogging.info(source, CoreLogging.getThrowableMessage(throwable, msg));
    }

    public static void info(@Nullable ICoreLoggingSource source, @NonNull String msg) {
        CoreLogging.getLogger(source).info(msg);
    }

    public static void severe(@NonNull Throwable throwable) {
        CoreLogging.severe(null, throwable, null);
    }

    public static void severe(@Nullable ICoreLoggingSource source, @NonNull Throwable throwable, @Nullable String msg) {
        throwable.printStackTrace();
        CoreLogging.severe(source, CoreLogging.getThrowableMessage(throwable, msg));
    }

    public static void severe(@Nullable ICoreLoggingSource source, @NonNull String msg) {
        CoreLogging.getLogger(source).severe(msg);
        Logger uiLogger = CoreLogging.getUserMessageLogger();
        if (uiLogger != null) {
            uiLogger.severe(msg);
        }
        assert (false);
    }

    public static void warning(@Nullable ICoreLoggingSource source, @NonNull Throwable throwable, @Nullable String msg) {
        CoreLogging.warning(source, CoreLogging.getThrowableMessage(throwable, msg));
    }

    public static void warning(@Nullable ICoreLoggingSource source, @NonNull String msg) {
        CoreLogging.log(source, Level.WARNING, msg);
    }

    public static void userMessageReportOnce(@Nullable ICoreLoggingSource source, @Nullable Level level, @NonNull String message) {
        if (!messagesToBeReportedOnce.contains(message)) {
            CoreLogging.userMessage(source, level, message);
            messagesToBeReportedOnce.add(message);
        }
    }

    public static void userMessage(@Nullable ICoreLoggingSource source, @Nullable Level level, @NonNull String msg) {
        Logger uiLogger = CoreLogging.getUserMessageLogger();
        if (uiLogger != null) {
            uiLogger.log(level, msg);
        }
        CoreLogging.log(source, level, msg);
    }

    private static @Nullable Logger getUserMessageLogger() {
        return LogManager.getLogManager().getLogger(USER_MESSAGE_LOGGER_NAME);
    }

    public static void trace(@Nullable ICoreLoggingSource source, @NonNull String msg) {
        CoreLogging.log(source, Level.FINE, msg);
    }

    public static void log(@Nullable ICoreLoggingSource source, @Nullable Level level, @NonNull Throwable throwable, @Nullable String msg) {
        CoreLogging.log(source, level, CoreLogging.getThrowableMessage(throwable, msg));
    }

    public static void log(@Nullable ICoreLoggingSource source, @Nullable Level level, @NonNull String msg) {
        CoreLogging.getLogger(source).log(level, msg);
    }

    public static void severeNoAssert(@Nullable ICoreLoggingSource source, @NonNull Throwable throwable, @Nullable String msg) {
        try {
            CoreLogging.severe(source, throwable, msg);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    public static void severeNoAssert(@Nullable ICoreLoggingSource source, @NonNull String msg) {
        try {
            CoreLogging.severe(source, msg);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    private static @NonNull String getThrowableMessage(@NonNull Throwable throwable, @Nullable String msg) {
        String throwableMsg = throwable.getMessage();
        if (throwableMsg == null) {
            throwableMsg = (String)NullUtils.neverNull((Object)throwable.toString());
        }
        return msg == null ? throwableMsg : String.valueOf(msg) + ": " + throwableMsg;
    }
}

