/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.util.IStatisticType;
import org.eclipse.jdt.annotation.NonNull;

public enum CommonStatistics implements IStatisticType
{
    NUMBER_OF_VERTICES("Number of vertices", "vertex", "vertices"),
    NUMBER_OF_DRAW_CALLS("Number of draw calls", "draw", "draws"),
    NUMBER_OF_INSTANCES("Number of instances", "instance", "instances"),
    NUMBER_OF_INSTANCED_VERTICES("Number of instanced vertices", "instanced vertex", "instanced vertices"),
    NUMBER_OF_INDICES("Number of indices", "index", "indices"),
    NUMBER_OF_UNIQUE_INDICES("Number of unique indices", "unique index", "unique indices"),
    NUMBER_OF_RENDER_PASSES("Number of render passes", "render pass", "render passes"),
    TOTAL_MEMORY_ALLOCATIONS("Total memory allocated (bytes)", "byte", "bytes"),
    TIME_SPENT_BLOCKED("Time spent blocked (seconds)", "second blocked", "seconds blocked", IStatisticType.NumberType.DOUBLE);

    private final @NonNull String title;
    private final @NonNull String unitName;
    private final @NonNull String pluralUnitName;
    private final @NonNull IStatisticType.NumberType numberType;

    private CommonStatistics(@NonNull String title, String unitName, String pluralUnitName) {
        this(title, unitName, pluralUnitName, IStatisticType.NumberType.LONG);
    }

    private CommonStatistics(@NonNull String title, @NonNull String unitName, String pluralUnitName, IStatisticType.NumberType numberType) {
        this.title = title;
        this.unitName = unitName;
        this.pluralUnitName = pluralUnitName;
        this.numberType = numberType;
    }

    @Override
    public String getUnitName() {
        return this.unitName;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getPluralUnitName() {
        return this.pluralUnitName;
    }

    @Override
    public IStatisticType.NumberType getNumberType() {
        return this.numberType;
    }
}

