/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.util.ComparatorUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class CollectionComparator<E extends Comparable<E>, T extends Collection<E>>
implements Comparator<T> {
    @Override
    public int compare(T o1, T o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        int sizeComparison = Integer.compare(o1.size(), o2.size());
        if (sizeComparison != 0) {
            return sizeComparison;
        }
        Iterator o1Iterator = o1.iterator();
        Iterator o2Iterator = o2.iterator();
        while (o1Iterator.hasNext()) {
            Comparable o2Item;
            Comparable o1Item = (Comparable)o1Iterator.next();
            int itemComparison = ComparatorUtils.compareNullables(o1Item, o2Item = (Comparable)o2Iterator.next());
            if (itemComparison == 0) continue;
            return itemComparison;
        }
        return 0;
    }
}

