/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.util.IHasStatistics;
import com.arm.mgd.core.util.IStatisticType;
import com.arm.mgd.core.util.Statistic;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class ChildrenStatisticsCache
implements IHasStatistics {
    private final @NonNull INavigationElement<?> parent;
    private final @NonNull Map<IStatisticType, Statistic> cachedStatsMap = new HashMap<IStatisticType, Statistic>();
    private final @NonNull Map<IStatisticType, Boolean> cachedHasDataMap = new HashMap<IStatisticType, Boolean>();

    public ChildrenStatisticsCache(@NonNull INavigationElement<?> parent) {
        this.parent = parent;
    }

    private boolean canCacheStats() {
        return this.parent.isTheChildrenListFinal();
    }

    public synchronized @NonNull Statistic getStat(@NonNull IStatisticType statsType) {
        Statistic cachedStat = this.cachedStatsMap.get(statsType);
        if (cachedStat != null) {
            return cachedStat;
        }
        Statistic stat = this.sumOfChildStatistics(statsType);
        if (this.canCacheStats()) {
            this.cachedStatsMap.put(statsType, stat);
        }
        return stat;
    }

    @Override
    public boolean hasDataForStatisticType(@NonNull IStatisticType statsType) {
        Boolean cachedHasData = this.cachedHasDataMap.get(statsType);
        if (cachedHasData != null) {
            return cachedHasData;
        }
        boolean supportedInChildren = this.calculateIfChildrenHaveDataForStatisticType(statsType);
        if (this.canCacheStats()) {
            this.cachedHasDataMap.put(statsType, supportedInChildren);
        }
        return supportedInChildren;
    }

    private boolean calculateIfChildrenHaveDataForStatisticType(@NonNull IStatisticType statsType) {
        boolean supportedInChildren = false;
        for (INavigationElement<?> child : this.parent.getChildren()) {
            if (!child.hasDataForStatisticType(statsType)) continue;
            supportedInChildren = true;
        }
        return supportedInChildren;
    }

    private @NonNull Statistic sumOfChildStatistics(@NonNull IStatisticType type) {
        switch (type.getNumberType()) {
            case DOUBLE: {
                return new Statistic(type, this.parent.getChildren().stream().filter(e -> e.hasDataForStatisticType(type)).mapToDouble(e -> e.getStatistic(type).getValue().doubleValue()).sum());
            }
            case LONG: {
                return new Statistic(type, this.parent.getChildren().stream().filter(e -> e.hasDataForStatisticType(type)).mapToLong(e -> e.getStatistic(type).getValue().longValue()).sum());
            }
        }
        throw new AssertionError((Object)("Number type " + (Object)((Object)type.getNumberType()) + " not supported"));
    }
}

