/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

public class ByteStringUtils {
    public static String byteRangeStringCreator(long rangeStartInBytes, long rangeEndInBytes) {
        assert (rangeStartInBytes >= 0L);
        assert (rangeStartInBytes < rangeEndInBytes);
        PowerAndSuffix powerAndSuffix = new PowerAndSuffix(rangeStartInBytes);
        return String.format("%s-%s%s", rangeStartInBytes / powerAndSuffix.powerAsDivisor(), rangeEndInBytes / powerAndSuffix.powerAsDivisor(), powerAndSuffix.suffix);
    }

    public static String byteStringCreator(long sizeInBytes) {
        assert (sizeInBytes >= 0L);
        PowerAndSuffix powerAndSuffix = new PowerAndSuffix(sizeInBytes);
        return String.format("%s%s", sizeInBytes / powerAndSuffix.powerAsDivisor(), powerAndSuffix.suffix);
    }

    private static class PowerAndSuffix {
        public final long power;
        public final String suffix;

        public PowerAndSuffix(long sizeInBytes) {
            double log1024size = Math.log(sizeInBytes) / (10.0 * Math.log(2.0));
            if (log1024size < 1.0) {
                this.suffix = "B";
                this.power = 0L;
            } else if (log1024size < 2.0) {
                this.suffix = "kB";
                this.power = 1L;
            } else if (log1024size < 3.0) {
                this.suffix = "MB";
                this.power = 2L;
            } else {
                this.suffix = "GB";
                this.power = 3L;
            }
        }

        public long powerAsDivisor() {
            return 1 << (int)(10L * this.power);
        }
    }
}

