/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.util.Neighbours;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BinarySearchList {
    public static <T> @NonNull Neighbours<@Nullable T> findNeighbours(@NonNull List<@NonNull T> sortedList, @NonNull Comparator<@NonNull T> comparator) {
        assert (sortedList != null);
        assert (comparator != null);
        if (sortedList.isEmpty()) {
            return new Neighbours<Object>(null, null, null);
        }
        return BinarySearchList.searchNeighbours(sortedList, comparator, 0, sortedList.size());
    }

    public static <T> int getIndexUsingComparator(@NonNull List<T> sortedList, @NonNull Comparator<T> comparator) {
        assert (sortedList != null);
        assert (comparator != null);
        return BinarySearchList.search(sortedList, comparator, 0, sortedList.size());
    }

    public static <T> @Nullable T usingComparator(@NonNull List<@NonNull T> sortedList, @NonNull Comparator<@NonNull T> comparator) {
        assert (sortedList != null);
        assert (comparator != null);
        int result = BinarySearchList.search(sortedList, comparator, 0, sortedList.size());
        if (result >= 0) {
            return sortedList.get(result);
        }
        return null;
    }

    private static <T> int search(@NonNull List<T> sortedList, @NonNull Comparator<T> comparator, int fromInclusive, int toExclusive) {
        if (fromInclusive >= toExclusive) {
            return -1;
        }
        int middle = (toExclusive - fromInclusive) / 2 + fromInclusive;
        T object = sortedList.get(middle);
        int comparison = comparator.compare(object);
        if (comparison == 0) {
            return middle;
        }
        if (comparison < 0) {
            return BinarySearchList.search(sortedList, comparator, middle + 1, toExclusive);
        }
        return BinarySearchList.search(sortedList, comparator, fromInclusive, middle);
    }

    private static <T> @NonNull Neighbours<@Nullable T> searchNeighbours(@NonNull List<@NonNull T> sortedList, @NonNull Comparator<@NonNull T> comparator, int fromInclusive, int toExclusive) {
        if (fromInclusive >= toExclusive) {
            if (fromInclusive >= sortedList.size()) {
                return new Neighbours<Object>(sortedList.get(sortedList.size() - 1), null, null);
            }
            if (toExclusive < 1) {
                return new Neighbours<Object>(null, null, sortedList.get(0));
            }
            int middle = (toExclusive - fromInclusive) / 2 + fromInclusive;
            T object = sortedList.get(middle);
            int comparison = comparator.compare(object);
            if (comparison < 0) {
                return new Neighbours<Object>((middle >= 0 ? (Object)sortedList.get(middle) : null), null, (middle + 1 < sortedList.size() ? (Object)sortedList.get(middle + 1) : null));
            }
            assert (comparison != 0);
            return new Neighbours<Object>((middle - 1 >= 0 ? (Object)sortedList.get(middle - 1) : null), null, (middle < sortedList.size() ? (Object)sortedList.get(middle) : null));
        }
        int middle = (toExclusive - fromInclusive) / 2 + fromInclusive;
        T object = sortedList.get(middle);
        int comparison = comparator.compare(object);
        if (comparison == 0) {
            return new Neighbours<Object>((middle - 1 >= 0 ? (Object)sortedList.get(middle - 1) : null), object, (middle + 1 < sortedList.size() ? (Object)sortedList.get(middle + 1) : null));
        }
        if (comparison < 0) {
            return BinarySearchList.searchNeighbours(sortedList, comparator, middle + 1, toExclusive);
        }
        return BinarySearchList.searchNeighbours(sortedList, comparator, fromInclusive, middle);
    }

    public static interface Comparator<T> {
        public int compare(T var1);
    }
}

