/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.util.BinarySearchList;
import com.arm.mgd.core.util.Neighbours;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.SortedSet;
import org.eclipse.jdt.annotation.NonNull;

public class BinarySearch {
    public static BinarySearchNeighbours findNeighbours(SortedSet<? extends @NonNull Number> set, int targetValue) {
        if (set == null || set.isEmpty()) {
            return new BinarySearchNeighbours(null, null);
        }
        Neighbours<Number> neighbours = BinarySearchList.findNeighbours(new ArrayList<Number>(set), n2 -> Integer.compare(((Number)NullUtils.neverNull((Object)n2)).intValue(), targetValue));
        Integer before = neighbours.getBefore() != null ? Integer.valueOf(((Number)NullUtils.neverNull((Object)neighbours.getBefore())).intValue()) : null;
        Integer after = neighbours.getAfter() != null ? Integer.valueOf(((Number)NullUtils.neverNull((Object)neighbours.getAfter())).intValue()) : null;
        return new BinarySearchNeighbours(before, after);
    }

    public static class BinarySearchNeighbours {
        static final BinarySearchNeighbours NULL = new BinarySearchNeighbours(null, null);
        public final Integer previous;
        public final Integer next;

        BinarySearchNeighbours(Integer previous, Integer next) {
            this.previous = previous;
            this.next = next;
        }

        BinarySearchNeighbours(Integer[] a, int prevIndex, int nextIndex) {
            this.previous = prevIndex >= 0 ? a[prevIndex] : null;
            this.next = nextIndex < a.length ? a[nextIndex] : null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BinarySearchNeighbours other = (BinarySearchNeighbours)obj;
            if (this.next == null ? other.next != null : !this.next.equals(other.next)) {
                return false;
            }
            return !(this.previous == null ? other.previous != null : !this.previous.equals(other.previous));
        }

        public String toString() {
            return String.format("prev: %d, next: %d", this.previous, this.next);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

