/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.util;

import com.arm.mgd.core.util.ProcessRunner;
import com.arm.mgd.utils.OSUtils;
import com.arm.mgd.utils.config.ProcessEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AppFinder {
    static ProcessEnvironment processEnvironment = new ProcessEnvironment();
    public static final @NonNull String ADB_EXEC_BASE_NAME = "adb";
    private static final @NonNull String WINDOWS_EXECUTABLE_SUFFIX = ".exe";

    public static boolean isValidExecutable(@Nullable File file) {
        return file != null && file.isFile() && file.canExecute();
    }

    private static @NonNull String getAppFinderCommand() {
        switch (OSUtils.OS) {
            case LINUX: 
            case MAC: {
                return "which";
            }
            case WINDOWS: {
                return "where.exe";
            }
        }
        throw new UnsupportedOperationException("Unsupported operating system: " + OSUtils.OS);
    }

    private static @Nullable File which(@NonNull String applicationFilename) throws IOException, InterruptedException {
        String trimmedOutput;
        String[] whichArgs = new String[]{AppFinder.getAppFinderCommand(), applicationFilename};
        ProcessRunner processRunner = new ProcessRunner(whichArgs, processEnvironment.getAllAsArray(), null);
        String output = processRunner.getStdout();
        String[] lines = output.split(System.lineSeparator());
        String detectedPath = null;
        if (lines.length != 0 && !(trimmedOutput = lines[0].trim()).isEmpty()) {
            detectedPath = trimmedOutput;
        }
        return detectedPath == null ? null : new File(detectedPath);
    }

    private static @NonNull List<File> getAndroidSDKRoots() {
        String[] sdkRoots;
        ArrayList<File> discoveredSDKRoots = new ArrayList<File>();
        String androidSDKPostfix = "/Android/android-sdk";
        String[] stringArray = sdkRoots = new String[]{processEnvironment.asString("ANDROID_HOME"), processEnvironment.asString("ANDROID_SDK_ROOT"), String.valueOf(Objects.toString(processEnvironment.asString("USERPROFILE"))) + "/AppData/Local" + "/Android/android-sdk", String.valueOf(Objects.toString(processEnvironment.asString("ProgramFiles"))) + "/Android/android-sdk", String.valueOf(Objects.toString(processEnvironment.asString("ProgramFiles(x86)"))) + "/Android/android-sdk"};
        int n = sdkRoots.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            String sdkRoot = stringArray[n2];
            if (sdkRoot != null && (file = new File(sdkRoot)).isDirectory()) {
                discoveredSDKRoots.add(file);
            }
            ++n2;
        }
        return discoveredSDKRoots;
    }

    private static @Nullable File getADBLocation() {
        for (File sdkRoot : AppFinder.getAndroidSDKRoots()) {
            String[] stringArray = new String[]{"", WINDOWS_EXECUTABLE_SUFFIX};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String suffix = stringArray[n2];
                File adb = new File(String.valueOf(sdkRoot.getAbsolutePath()) + "/platform-tools/" + ADB_EXEC_BASE_NAME + suffix);
                if (adb.canExecute()) {
                    return adb;
                }
                ++n2;
            }
        }
        return null;
    }

    public static @Nullable File locate(@NonNull String basename) throws IOException, InterruptedException {
        File returnValue;
        block7: {
            returnValue = AppFinder.which(basename);
            if (returnValue != null && AppFinder.isValidExecutable(returnValue)) break block7;
            switch (basename) {
                case "adb": {
                    return AppFinder.getADBLocation();
                }
            }
        }
        return AppFinder.isValidExecutable(returnValue) ? returnValue : null;
    }

    static void overrideEnvironment(@NonNull String key, @NonNull String value) {
        processEnvironment.put(key, value);
    }

    static void resetEnvironment() {
        processEnvironment = new ProcessEnvironment();
    }
}

