/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.traceanalyses;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.traceanalyses.APIErrorAnalyzer;
import com.arm.mgd.core.traceanalyses.AbstractTraceAnalyzer;
import com.arm.mgd.core.traceanalyses.ApiAnalysis;
import com.arm.mgd.core.traceanalyses.GLES11Analyzer;
import com.arm.mgd.core.traceanalyses.GlProgramBinaryAnalyzer;
import com.arm.mgd.core.traceanalyses.GlReadPixelsAnalyzer;
import com.arm.mgd.core.traceanalyses.GlTrianglesAnalyzer;
import com.arm.mgd.core.traceanalyses.IndicesSparsenessAnalyzer;
import com.arm.mgd.core.traceanalyses.MultisampledSurfacesAnalyzer;
import com.arm.mgd.core.traceanalyses.TraceAnalysis;
import com.arm.mgd.core.traceanalyses.TraceAnalysisModelListener;
import com.arm.mgd.core.util.ListenerList;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TraceAnalysisModel {
    private final Map<String, TraceAnalysis> analyses = new ConcurrentHashMap<String, TraceAnalysis>();
    private final ArrayList<AbstractTraceAnalyzer> analyzers = new ArrayList();
    public final ListenerList<TraceAnalysisModelListener> listeners = new ListenerList();
    private final TraceDataModel traceModel;
    private int nextFunctionToProcess = 0;

    public TraceAnalysisModel(@NonNull TraceDataModel model) {
        this.traceModel = model;
        this.analyzers.add(new GlTrianglesAnalyzer(this));
        this.analyzers.add(new GlReadPixelsAnalyzer(this));
        this.analyzers.add(new APIErrorAnalyzer(this));
        this.analyzers.add(new IndicesSparsenessAnalyzer(this));
        this.analyzers.add(new GLES11Analyzer(this));
        this.analyzers.add(new MultisampledSurfacesAnalyzer(this));
        this.analyzers.add(new GlProgramBinaryAnalyzer(this));
    }

    public Collection<TraceAnalysis> getAnalyses() {
        return Collections.unmodifiableCollection(this.analyses.values());
    }

    public TraceDataModel getTraceModel() {
        return this.traceModel;
    }

    public void addAnalysis(@NonNull TraceAnalysis analysis) {
        this.addAnalysis(analysis, null);
    }

    public void addAnalysis(@NonNull TraceAnalysis.AnalysisType type, @NonNull String message, @NonNull String description, @Nullable FunctionCall relevantFunctionCall) {
        this.addAnalysis(new ApiAnalysis(type, message, description, relevantFunctionCall), relevantFunctionCall);
    }

    private synchronized void addAnalysis(@NonNull TraceAnalysis analysis, @Nullable FunctionCall relevantFunctionCall) {
        String key = analysis.getKey();
        if (this.analyses.containsKey(key)) {
            @NonNull TraceAnalysis instance = (TraceAnalysis)NullUtils.neverNull((Object)this.analyses.get(key));
            if (relevantFunctionCall != null) {
                instance.addLocation(relevantFunctionCall.getIndex());
                this.notifyAnalysisChanged(instance);
            }
        } else {
            this.analyses.put(key, analysis);
            this.notifyAnalysisAdded(analysis);
        }
    }

    public synchronized void removeAnalysis(TraceAnalysis analysis) {
        TraceAnalysis analysisRemoved = this.analyses.remove(analysis.getKey());
        if (analysisRemoved != null) {
            this.notifyAnalysisRemoved(analysis);
        }
    }

    public synchronized void analysisChanged(TraceAnalysis analysisChanged) {
        if (analysisChanged != null) {
            this.notifyAnalysisChanged(analysisChanged);
        }
    }

    private void notifyAnalysisAdded(TraceAnalysis analysisAdded) {
        for (TraceAnalysisModelListener listener : this.listeners) {
            listener.onTraceAnalysisAdded(analysisAdded);
        }
    }

    private void notifyAnalysisChanged(TraceAnalysis analysisChanged) {
        for (TraceAnalysisModelListener listener : this.listeners) {
            listener.onTraceAnalysisChanged(analysisChanged);
        }
    }

    private void notifyAnalysisRemoved(TraceAnalysis analysisRemoved) {
        for (TraceAnalysisModelListener listener : this.listeners) {
            listener.onTraceAnalysisRemoved(analysisRemoved);
        }
    }

    public synchronized void evaluateAll() {
        while (this.nextFunctionToProcess < this.traceModel.count()) {
            if (!this.traceModel.isClosed()) {
                FunctionCall fc = this.traceModel.getCallItem(this.nextFunctionToProcess);
                for (AbstractTraceAnalyzer analyzer : this.analyzers) {
                    analyzer.evaluate(fc);
                }
            }
            ++this.nextFunctionToProcess;
        }
    }
}

