/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.traceanalyses;

import com.arm.mgd.utils.NullUtils;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;

public class TraceAnalysis {
    private final @NonNull AnalysisType type;
    private final @NonNull String message;
    private final @NonNull String description;
    protected final @NonNull TreeSet<@NonNull Integer> analysisLocations = new TreeSet();

    public TraceAnalysis(@NonNull AnalysisType type, @NonNull String message, @NonNull String description) {
        this.type = type;
        this.message = message;
        this.description = description;
    }

    public @NonNull AnalysisType getType() {
        return this.type;
    }

    public @NonNull String getDescription() {
        return this.description;
    }

    public @NonNull String getMessage() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocation(int fcIndex) {
        TreeSet<Integer> treeSet = this.analysisLocations;
        synchronized (treeSet) {
            this.analysisLocations.add(NullUtils.intValueOf((int)fcIndex));
        }
    }

    public int getCount() {
        return this.analysisLocations.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<? super @NonNull Integer> copyLocations(@NonNull Set<? super @NonNull Integer> into) {
        TreeSet<Integer> treeSet = this.analysisLocations;
        synchronized (treeSet) {
            into.addAll(this.analysisLocations);
        }
        return into;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TraceAnalysis)) {
            return false;
        }
        TraceAnalysis otherProblem = (TraceAnalysis)other;
        return this.getKey().equals(otherProblem.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String getKey() {
        return (Object)((Object)this.type) + ":" + this.message;
    }

    public static enum AnalysisType {
        INFO,
        WARNING,
        ERROR;

    }
}

