/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.traceanalyses;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.traceanalyses.AbstractTraceAnalyzer;
import com.arm.mgd.core.traceanalyses.TraceAnalysis;
import com.arm.mgd.core.traceanalyses.TraceAnalysisModel;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

class MultisampledSurfacesAnalyzer
extends AbstractTraceAnalyzer {
    private static final Set<IFunctionOrAliasSpecExtended> MULTISAMPLED_FUNCTIONS = new HashSet<IFunctionOrAliasSpecExtended>(){
        {
            this.add(KapiSpec.GLES.functions.GLRENDERBUFFERSTORAGEMULTISAMPLE);
            this.add(KapiSpec.GLES.functions.GLTEXSTORAGE2DMULTISAMPLE);
            this.add(KapiSpec.GLES.functions.GLFRAMEBUFFERTEXTURE2DMULTISAMPLEEXT);
            this.add(KapiSpec.GLES.functions.GLTEXSTORAGE3DMULTISAMPLE);
        }
    };
    private long counter = 0L;

    MultisampledSurfacesAnalyzer(@NonNull TraceAnalysisModel model) {
        super(model, new TraceAnalysis(TraceAnalysis.AnalysisType.WARNING, "Multisampled Renderbuffer / Texture detected. Frame capture may not work for draw calls to framebuffers which use these as attachments.", "Multisampled attachments are currently not supported for frame capture on all attachment / format combinations.\n\nCapturing multisampled attachments may also be slower."));
    }

    @Override
    protected boolean isVisible() {
        return this.counter > 0L;
    }

    @Override
    protected boolean processCall(@NonNull FunctionCall fc) {
        if (MULTISAMPLED_FUNCTIONS.contains(fc.getFunctionSpec())) {
            ++this.counter;
            this.problem.addLocation(fc.getIndex());
            return true;
        }
        return false;
    }
}

