/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.traceanalyses;

import com.arm.mgd.core.asset.DrawCallData;
import com.arm.mgd.core.asset.DrawElementsCallData;
import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.traceanalyses.AbstractMutableMessageTraceAnalyzer;
import com.arm.mgd.core.traceanalyses.MutableMessageTraceAnalysis;
import com.arm.mgd.core.traceanalyses.TraceAnalysis;
import com.arm.mgd.core.traceanalyses.TraceAnalysisModel;
import com.arm.mgd.core.util.CommonStatistics;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;

class IndicesSparsenessAnalyzer
extends AbstractMutableMessageTraceAnalyzer {
    private static float SPARSENESS_THRESHOLD = 1.0f;
    private long cumulativeRange;
    private long cumulativeIndices;

    IndicesSparsenessAnalyzer(@NonNull TraceAnalysisModel model) {
        super(model, new MutableMessageTraceAnalysis(TraceAnalysis.AnalysisType.WARNING, "Draw call indices buffer may be too sparse.", "Try to reorder the indices to make the buffer more compact."));
    }

    @Override
    protected boolean processCall(@NonNull FunctionCall fc) {
        DrawCallData data;
        boolean changed = false;
        if (fc instanceof DrawFunctionCall && (data = ((DrawFunctionCall)fc).getDrawCallData()) instanceof DrawElementsCallData) {
            DrawElementsCallData drawElementsCallData = (DrawElementsCallData)data;
            assert (drawElementsCallData.hasDataForStatisticType(CommonStatistics.NUMBER_OF_UNIQUE_INDICES));
            this.cumulativeIndices += drawElementsCallData.getStatistic(CommonStatistics.NUMBER_OF_UNIQUE_INDICES).getValue().longValue();
            this.cumulativeRange += drawElementsCallData.getIndexRange();
            if (drawElementsCallData.getSparseness() > SPARSENESS_THRESHOLD && !Float.isInfinite(drawElementsCallData.getSparseness())) {
                this.problem.addLocation(fc.getIndex());
            }
            this.updateMessage();
            changed = true;
        }
        return changed;
    }

    @Override
    protected @NonNull String getUpdatedMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Draw call indices buffer may be too sparse.");
        float overallSparseness = DrawElementsCallData.calculateSparseness(this.cumulativeRange, this.cumulativeIndices);
        if (!Float.isInfinite(overallSparseness)) {
            sb.append(String.format(" (Total sparseness > %.2f)", Float.valueOf(overallSparseness)));
        }
        return (String)NullUtils.neverNull((Object)sb.toString());
    }
}

