/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.traceanalyses;

import com.arm.mgd.core.asset.DrawCallData;
import com.arm.mgd.core.counters.Counters;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.traceanalyses.AbstractMutableMessageTraceAnalyzer;
import com.arm.mgd.core.traceanalyses.MutableMessageTraceAnalysis;
import com.arm.mgd.core.traceanalyses.TraceAnalysis;
import com.arm.mgd.core.traceanalyses.TraceAnalysisModel;
import com.arm.mgd.kapi.AbstractConstantOrAliasSpec;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;

class GlTrianglesAnalyzer
extends AbstractMutableMessageTraceAnalyzer {
    private long drawCallsUsingTriangles = 0L;

    GlTrianglesAnalyzer(@NonNull TraceAnalysisModel model) {
        super(model, new MutableMessageTraceAnalysis(TraceAnalysis.AnalysisType.INFO, "Some of the draw calls are using GL_TRIANGLES.", "You should consider using GL_TRIANGLE_STRIP to reduce the number of vertices."));
    }

    @Override
    protected boolean processCall(@NonNull FunctionCall fc) {
        DrawFunctionCall dfc;
        DrawCallData drawCallData;
        if (fc.hasError()) {
            return false;
        }
        AbstractConstantOrAliasSpec mode = null;
        if (fc instanceof DrawFunctionCall && (drawCallData = (dfc = (DrawFunctionCall)fc).getDrawCallData()) != null) {
            mode = drawCallData.getMode();
        }
        boolean changed = false;
        if (mode != null) {
            changed = true;
        }
        if (KapiSpec.GLES.constants.GL_TRIANGLES.equals(mode)) {
            ++this.drawCallsUsingTriangles;
            this.problem.addLocation(fc.getIndex());
            changed = true;
        }
        if (changed) {
            this.updateMessage();
        }
        return changed;
    }

    @Override
    protected @NonNull String getUpdatedMessage() {
        Counters counters = this.model.getTraceModel().getCounters();
        double usingTrianglesRatio = (double)this.drawCallsUsingTriangles / (double)counters.totalDrawCalls;
        Double ratioAsPercentage = NullUtils.doubleValueOf((double)Math.min(100.0, 100.0 * usingTrianglesRatio));
        return NullUtils.formattedString((String)"%.2f%% of the draw calls are using GL_TRIANGLES.", (Object[])new Object[]{ratioAsPercentage});
    }
}

