/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.traceanalyses;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.traceanalyses.AbstractTraceAnalyzer;
import com.arm.mgd.core.traceanalyses.TraceAnalysis;
import com.arm.mgd.core.traceanalyses.TraceAnalysisModel;
import org.eclipse.jdt.annotation.NonNull;

class GlReadPixelsAnalyzer
extends AbstractTraceAnalyzer {
    private long totalCallsToGlReadPixels;

    GlReadPixelsAnalyzer(@NonNull TraceAnalysisModel model) {
        super(model, new TraceAnalysis(TraceAnalysis.AnalysisType.WARNING, "glReadPixels() called.", "glReadPixels causes a pipeline flush and should be avoided if possible."));
    }

    @Override
    protected boolean processCall(@NonNull FunctionCall fc) {
        if (KapiSpec.GLES.functions.GLREADPIXELS.equals(fc.getFunctionSpec())) {
            ++this.totalCallsToGlReadPixels;
            this.problem.addLocation(fc.getIndex());
            return true;
        }
        return false;
    }

    @Override
    protected boolean isVisible() {
        return this.totalCallsToGlReadPixels > 0L;
    }
}

