/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.traceanalyses;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.traceanalyses.AbstractTraceAnalyzer;
import com.arm.mgd.core.traceanalyses.TraceAnalysis;
import com.arm.mgd.core.traceanalyses.TraceAnalysisModel;
import com.arm.mgd.utils.VersionProperties;
import org.eclipse.jdt.annotation.NonNull;

class GlProgramBinaryAnalyzer
extends AbstractTraceAnalyzer {
    private long totalCallsToGlProgramBinary;

    GlProgramBinaryAnalyzer(@NonNull TraceAnalysisModel model) {
        super(model, new TraceAnalysis(TraceAnalysis.AnalysisType.WARNING, String.valueOf(VersionProperties.FULL_PRODUCT_NAME) + " has overridden the 'binaryFormat' parameter of this function.", "When an application executes glProgramBinary, " + VersionProperties.SHORT_PRODUCT_NAME + " sets the 'binaryFormat' parameter to zero forcing the application to compile the shader. " + "This allows " + VersionProperties.SHORT_PRODUCT_NAME + " to provide analysis on the shader code."));
    }

    @Override
    protected boolean processCall(@NonNull FunctionCall fc) {
        if (KapiSpec.GLES.functions.GLPROGRAMBINARY.equals(fc.getFunctionSpec())) {
            ++this.totalCallsToGlProgramBinary;
            this.problem.addLocation(fc.getIndex());
            return true;
        }
        return false;
    }

    @Override
    protected boolean isVisible() {
        return this.totalCallsToGlProgramBinary > 0L;
    }
}

