/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.traceanalyses;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.traceanalyses.AbstractTraceAnalyzer;
import com.arm.mgd.core.traceanalyses.TraceAnalysis;
import com.arm.mgd.core.traceanalyses.TraceAnalysisModel;
import com.arm.mgd.kapi.gen.ApiName;
import com.arm.mgd.kapi.gen.VersionsSpec;
import com.arm.mgd.utils.VersionProperties;
import org.eclipse.jdt.annotation.NonNull;

class GLES11Analyzer
extends AbstractTraceAnalyzer {
    private long usingGLES1;

    GLES11Analyzer(@NonNull TraceAnalysisModel model) {
        super(model, new TraceAnalysis(TraceAnalysis.AnalysisType.WARNING, "The application appears to be calling OpenGL ES 1.1 entry points.", "The OpenGL ES 1.1 API is unsupported by " + VersionProperties.FULL_PRODUCT_NAME + ". " + "Function calls will be traced but the state may not be displayed correctly."));
    }

    @Override
    protected boolean processCall(@NonNull FunctionCall fc) {
        IFunctionOrAliasSpecExtended functionSpec = fc.getFunctionSpec();
        if (functionSpec.getAsFunctionSpec().getKapiSpec().getApi().getApiInfo().getName() == ApiName.GLES) {
            VersionsSpec version = functionSpec.getVersionInfo();
            Float minVersion = version.getMin();
            Float maxVersion = version.getMax();
            if (minVersion != null && maxVersion != null && minVersion.floatValue() < 2.0f && maxVersion.floatValue() < 2.0f) {
                ++this.usingGLES1;
                this.problem.addLocation(fc.getIndex());
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isVisible() {
        return this.usingGLES1 > 0L;
    }
}

