/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.traceanalyses;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.traceanalyses.TraceAnalysis;
import com.arm.mgd.core.traceanalyses.TraceAnalysisModel;
import org.eclipse.jdt.annotation.NonNull;

abstract class AbstractTraceAnalyzer {
    protected final @NonNull TraceAnalysis problem;
    protected final @NonNull TraceAnalysisModel model;

    AbstractTraceAnalyzer(@NonNull TraceAnalysisModel model, @NonNull TraceAnalysis problem) {
        this.model = model;
        this.problem = problem;
    }

    protected abstract boolean processCall(@NonNull FunctionCall var1);

    protected void evaluate(@NonNull FunctionCall fc) {
        boolean wasVisible = this.isVisible();
        boolean changed = this.processCall(fc);
        if (changed) {
            if (!wasVisible && this.isVisible()) {
                this.model.addAnalysis(this.problem);
            } else if (wasVisible && !this.isVisible()) {
                this.model.removeAnalysis(this.problem);
            } else if (wasVisible && this.isVisible()) {
                this.model.analysisChanged(this.problem);
            }
        }
    }

    protected boolean isVisible() {
        return this.problem.getCount() > 0;
    }
}

