/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.traceanalyses;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.traceanalyses.AbstractTraceAnalyzer;
import com.arm.mgd.core.traceanalyses.TraceAnalysis;
import com.arm.mgd.core.traceanalyses.TraceAnalysisModel;
import org.eclipse.jdt.annotation.NonNull;

class APIErrorAnalyzer
extends AbstractTraceAnalyzer {
    private long numberOfErrorsReturned;

    APIErrorAnalyzer(@NonNull TraceAnalysisModel model) {
        super(model, new TraceAnalysis(TraceAnalysis.AnalysisType.ERROR, "API call returned an error code.", "An intercepted API function returned an error code."));
    }

    @Override
    protected boolean processCall(@NonNull FunctionCall fc) {
        if (fc.hasError()) {
            ++this.numberOfErrorsReturned;
            this.problem.addLocation(fc.getIndex());
            return true;
        }
        return false;
    }

    @Override
    protected boolean isVisible() {
        return this.numberOfErrorsReturned > 0L;
    }
}

