/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.utils;

import java.util.Date;
import org.eclipse.jdt.annotation.NonNull;

public final class Timestamp
implements Comparable<Timestamp> {
    private final long timeValue;

    public Timestamp(int highWord, int lowWord) {
        this.timeValue = ((long)highWord & 0xFFFFFFFFL) << 32 | (long)lowWord & 0xFFFFFFFFL;
    }

    public Timestamp(long timeValue) {
        this.timeValue = timeValue;
    }

    public @NonNull Date asDate() {
        return new Date(this.timeValue);
    }

    public long asLong() {
        return this.timeValue;
    }

    @Override
    public int compareTo(Timestamp o) {
        return Long.compare(this.timeValue, o.timeValue);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Timestamp)) {
            return false;
        }
        Timestamp that = (Timestamp)obj;
        return this.timeValue == that.timeValue;
    }

    public int getHighWord() {
        return (int)(this.timeValue >> 32);
    }

    public int getLowWord() {
        return (int)this.timeValue;
    }

    public int hashCode() {
        return Long.hashCode(this.timeValue);
    }

    public String toString() {
        return String.valueOf(this.timeValue);
    }
}

