/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.utils;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.ProcessConfigHistory;
import com.arm.mgd.core.target.io.ProcessMarshaller;
import com.arm.mgd.core.target.io.ProcessTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ReplayValidator {
    public static @NonNull ReplayabilityAnalysis isProcessReplayable(int pid, @NonNull AbstractTarget target) throws ProcessMarshaller.NoProcessFoundException {
        if (ProcessMarshaller.getPidsFromTarget(target).noneMatch(x -> x == pid)) {
            throw new ProcessMarshaller.NoProcessFoundException(pid);
        }
        ReplayabilityAnalysis analysis = new ReplayabilityAnalysis();
        List processes = target.getModels().stream().filter(m -> m.getProcessID() == pid).map(m -> m.getParentProcessTarget()).collect(Collectors.toList());
        if (processes.size() > 1) {
            analysis.addReasonForFailure(ReplayFailureCondition.MULTIPLE_MATCHING_PROCESSES);
            return analysis;
        }
        ProcessTarget process = (ProcessTarget)processes.get(0);
        TraceDataModel model = process.getModel();
        if (model.processStartedBeforeTracing()) {
            analysis.addReasonForFailure(ReplayFailureCondition.PROCESS_STARTED_BEFORE_TRACING);
        }
        ReplayValidator.analyseFunctionCallsFromModel(model, process, analysis);
        return analysis;
    }

    private static void analyseFunctionCallsFromModel(@NonNull TraceDataModel model, @NonNull ProcessTarget process, @NonNull ReplayabilityAnalysis analysis) {
        if (model.containsCL()) {
            analysis.addReasonForFailure(ReplayFailureCondition.CONTAINS_CL);
        }
        if (model.containsVULKAN()) {
            analysis.addReasonForFailure(ReplayFailureCondition.CONTAINS_VULKAN);
        }
        if (!model.containsGLES() && !model.containsEGL()) {
            analysis.addReasonForFailure(ReplayFailureCondition.NO_GLES_CALLS);
        }
        if (model.count() > 0) {
            FunctionCall firstFC = model.getCallItem(0);
            ProcessConfigHistory.Range configs = process.getProcessConfigsAtCallItem(firstFC);
            if (!configs.processConfigStart.processConfig.isFullTrace()) {
                analysis.addReasonForFailure(ReplayFailureCondition.STARTED_WITHOUT_FULL_TRACE);
            }
            @Nullable ProcessConfigHistory processConfigEnd = configs.processConfigEnd;
            while (processConfigEnd != null) {
                if (!processConfigEnd.processConfig.isFullTrace()) {
                    analysis.addReasonForFailure(ReplayFailureCondition.FULL_TRACE_WAS_DISABLED);
                    break;
                }
                processConfigEnd = process.getProcessConfigsAtCallItem((FunctionCall)model.getCallItem((int)processConfigEnd.functionCallIndexFromInclusive)).processConfigEnd;
            }
        }
    }

    public static enum ReplayFailureCondition {
        MULTIPLE_MATCHING_PROCESSES("Multiple processes found matching process ID."),
        PROCESS_STARTED_BEFORE_TRACING("Process started before tracing started."),
        CONTAINS_CL("Process contains unsupported API calls (OpenCL) for Full Trace Replay."),
        CONTAINS_VULKAN("Process contains unsupported API calls (Vulkan) for Full Trace Replay."),
        NO_GLES_CALLS("Process contains no replayable API calls (expected OpenGL ES and/or EGL calls)."),
        STARTED_WITHOUT_FULL_TRACE("Process was recorded without Full Trace configuration enabled from the start."),
        FULL_TRACE_WAS_DISABLED("Process was recorded without Full Trace configuration enabled for the entire trace.");

        private final @NonNull String description;

        private ReplayFailureCondition(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static class ReplayabilityAnalysis {
        private final @NonNull List<@NonNull ReplayFailureCondition> reasonsForFailure = new ArrayList<ReplayFailureCondition>();

        public boolean isReplayable() {
            return this.reasonsForFailure.isEmpty();
        }

        public @NonNull List<@NonNull ReplayFailureCondition> getReasonsForFailure() {
            return this.reasonsForFailure;
        }

        public void addReasonForFailure(@NonNull ReplayFailureCondition reason) {
            this.reasonsForFailure.add(reason);
        }
    }
}

