/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.utils;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.pb.v2.MgdProtosV2;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.AbstractOverrideAttachment;
import com.arm.mgd.core.target.data.ArgumentContainerHelper;
import com.arm.mgd.core.target.data.FrameFeaturesFlagsEnum;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IArgumentAttachment;
import com.arm.mgd.core.target.marshaller.utils.Timestamp;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionCallDescriptor {
    private final @NonNull List<@NonNull Serializable> arguments;
    private final @Nullable Integer errorCode;
    private final @NonNull Set<@NonNull FrameFeaturesFlagsEnum> featuresEnabled;
    private final boolean frameEnd;
    private final @NonNull List<@NonNull AbstractOverrideAttachment> frameOverrides;
    private final @NonNull List<@NonNull AbstractFreeAttachment> freeAttachments;
    private final @NonNull IFunctionOrAliasSpecExtended functionSpec;
    private final boolean hidden;
    private final boolean missingFunctionCalled;
    private @Nullable String notes;
    private final int processId;
    private final @Nullable Serializable returnValue;
    private final long threadId;
    private final @NonNull Timestamp timestampStart;
    private final @NonNull Timestamp timestampStop;
    private final @Nullable Integer asynchronousFunctionCallUid;

    public FunctionCallDescriptor(int processId, long threadId, @NonNull Timestamp timestampStart, @NonNull Timestamp timestampStop, @NonNull IFunctionOrAliasSpecExtended functionSpec, int errorCode, @Nullable Serializable returnValue, @NonNull List<@NonNull Serializable> arguments, boolean frameEnd, @NonNull List< @NonNull MgdProtosV2.FunctionCallFlagsEnumProto> flags, @Nullable String notes, @NonNull List<@NonNull AbstractFreeAttachment> freeAttachments, @NonNull Set<@NonNull FrameFeaturesFlagsEnum> featuresEnabled, @NonNull List<@NonNull AbstractOverrideAttachment> frameOverrides, @Nullable Integer asynchronousFunctionCallUid) {
        this.processId = processId;
        this.threadId = threadId;
        this.timestampStart = timestampStart;
        this.timestampStop = timestampStop;
        this.functionSpec = functionSpec;
        this.errorCode = errorCode;
        this.returnValue = returnValue;
        this.arguments = arguments;
        this.missingFunctionCalled = flags.contains((Object)MgdProtosV2.FunctionCallFlagsEnumProto.FC_FLAG_MISSING_FUNCTION_CALLED);
        this.frameEnd = frameEnd;
        this.hidden = flags.contains((Object)MgdProtosV2.FunctionCallFlagsEnumProto.FC_FLAG_HIDDEN_FUNCTION);
        this.notes = notes;
        this.freeAttachments = freeAttachments;
        this.featuresEnabled = featuresEnabled;
        this.frameOverrides = frameOverrides;
        this.asynchronousFunctionCallUid = asynchronousFunctionCallUid;
    }

    public Serializable[] getArgumentsAsArray(@NonNull FunctionCall functionCall) {
        Serializable[] result = this.arguments.toArray(new Serializable[this.arguments.size()]);
        int i = 0;
        while (i < result.length) {
            Serializable argValue = result[i];
            if (argValue instanceof IArgumentAttachment) {
                ArgumentSpec argumentSpec = functionCall.getFunctionSpec().getArg().get(i);
                assert (argumentSpec != null) : "ArgumentSpec for " + functionCall + " argument #" + i + " is null.";
                ArgumentContainerHelper.setTypeIfContainer((IArgumentAttachment)argValue, argumentSpec);
                IArgumentAttachment argumentAttachment = (IArgumentAttachment)argValue;
                argumentAttachment.setParent(functionCall, i);
            }
            ++i;
        }
        return result;
    }

    public @Nullable Integer getErrorCode() {
        return this.errorCode;
    }

    public @NonNull Set<@NonNull FrameFeaturesFlagsEnum> getFeaturesEnabled() {
        return this.featuresEnabled;
    }

    public @NonNull List<@NonNull AbstractOverrideAttachment> getFrameOverrides() {
        return this.frameOverrides;
    }

    public @NonNull List<@NonNull AbstractFreeAttachment> getFreeAttachments(@NonNull FunctionCall functionCall) {
        this.freeAttachments.forEach(a -> a.setParentFunctionCall(functionCall));
        return this.freeAttachments;
    }

    public @NonNull IFunctionOrAliasSpecExtended getFunctionSpec() {
        return this.functionSpec;
    }

    public @Nullable String getNotes() {
        return this.notes;
    }

    public int getProcessId() {
        return this.processId;
    }

    public @Nullable Serializable getReturnValue() {
        return this.returnValue;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public @NonNull Timestamp getTimestampStart() {
        return this.timestampStart;
    }

    public @NonNull Timestamp getTimestampStop() {
        return this.timestampStop;
    }

    public boolean isFrameEnd() {
        return this.frameEnd;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isMissingFunctionCalled() {
        return this.missingFunctionCalled;
    }

    public void setNotes(@Nullable String notes) {
        this.notes = notes;
    }

    public @NonNull List<@NonNull AbstractFreeAttachment> getFreeAttachments() {
        return this.freeAttachments;
    }

    public @Nullable Integer getAsynchronousFunctionCallUid() {
        return this.asynchronousFunctionCallUid;
    }
}

