/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.utils;

import com.arm.mgd.core.kapi.IConstantOrAliasSpecContainer;
import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.lang.handle.HandleArrayAttachment;
import com.arm.mgd.core.lang.handle.HandleAttachment;
import com.arm.mgd.core.lang.handle.IHandleType;
import com.arm.mgd.core.midstream.AssetReference;
import com.arm.mgd.core.target.data.ArgumentContainerArrayAttachment;
import com.arm.mgd.core.target.data.ArgumentContainerAttachment;
import com.arm.mgd.core.target.data.BufferArgAttachment;
import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.IArgumentAttachment;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.StringsArgAttachment;
import com.arm.mgd.core.target.data.TextureArgAttachment;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.extended.ReturnTypeSpec;
import com.arm.mgd.kapi.extended.UsageSpec;
import com.arm.mgd.kapi.gen.ArraySpec;
import com.arm.mgd.kapi.gen.BasicTypeRefSpec;
import com.arm.mgd.kapi.gen.ElementTypeSpec;
import com.arm.mgd.kapi.gen.FormatSpec;
import com.arm.mgd.kapi.gen.ScalarSpec;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionCallArgumentDescriptor {
    private final @Nullable IArgumentAttachment attachmentValue;
    private final @Nullable IByteDataProvider data;
    private final @Nullable Serializable objectValue;

    public static @NonNull FunctionCallArgumentDescriptor create(@Nullable Integer intValue, @Nullable Long longValue, @Nullable Float floatValue, @Nullable Double doubleValue, @Nullable IByteDataProvider data, @Nullable StringsArgAttachment strings, @Nullable LongsArgAttachment longs, @Nullable FloatsArgAttachment floats, @Nullable Pointer ptrValue, @Nullable ArgumentContainerAttachment container, @Nullable ArgumentContainerArrayAttachment containers) {
        if (ptrValue != null) {
            return new FunctionCallArgumentDescriptor(ptrValue, data, FunctionCallArgumentDescriptor.whichArgumentAttachmentToUse(strings, longs, floats, longValue, container, containers));
        }
        return new FunctionCallArgumentDescriptor(FunctionCallArgumentDescriptor.whichArgumentValueToUse(intValue, longValue, floatValue, doubleValue, container, containers), null, null);
    }

    public static @NonNull FunctionCallArgumentDescriptor fromValue(@NonNull Serializable object) {
        if (object instanceof IHandleType) {
            IHandleType vulkanTypeObject = (IHandleType)((Object)object);
            return vulkanTypeObject.getOriginalObjectFunctionCallArgumentDescriptor();
        }
        if (object instanceof TextureArgAttachment) {
            TextureArgAttachment textureArgAttachment = (TextureArgAttachment)object;
            return new FunctionCallArgumentDescriptor(textureArgAttachment.getOriginalValue(), textureArgAttachment.getData(), null);
        }
        if (object instanceof BufferArgAttachment) {
            BufferArgAttachment bufferArgAttachment = (BufferArgAttachment)object;
            return new FunctionCallArgumentDescriptor(bufferArgAttachment.getOriginalValue(), bufferArgAttachment.getData(), null);
        }
        if (object instanceof IArgumentAttachment) {
            IArgumentAttachment argAttachment = (IArgumentAttachment)object;
            return new FunctionCallArgumentDescriptor(argAttachment.getOriginalValue(), null, argAttachment);
        }
        if (object instanceof AbstractConstantOrAliasSpecExtended) {
            AbstractConstantOrAliasSpecExtended constant = (AbstractConstantOrAliasSpecExtended)object;
            return new FunctionCallArgumentDescriptor(constant.getResolvedValue(), null, null);
        }
        return new FunctionCallArgumentDescriptor(object, null, null);
    }

    public static @Nullable Serializable convertConstantValue(UsageSpec usage, Serializable objectToConvert) {
        if (objectToConvert != null && usage != null && objectToConvert instanceof Number) {
            objectToConvert = !usage.isBitfield() ? usage.getConstantSpecByValue(NullUtils.longValueOf((long)((Number)objectToConvert).longValue())) : usage.getBitfieldByValue(NullUtils.longValueOf((long)((Number)objectToConvert).longValue()));
        }
        return objectToConvert;
    }

    private static @NonNull Serializable updateArgAttachment(@NonNull Pointer orignalPointer, @NonNull IArgumentAttachment attachment) {
        attachment.setOriginalPointerValue(orignalPointer);
        return attachment;
    }

    private static @Nullable IArgumentAttachment whichArgumentAttachmentToUse(@Nullable StringsArgAttachment strings, @Nullable LongsArgAttachment longs, @Nullable FloatsArgAttachment floats, @Nullable Long longValue, @Nullable ArgumentContainerAttachment container, @Nullable ArgumentContainerArrayAttachment containers) {
        if (longValue != null) {
            return new LongPtrArgAttachment(longValue);
        }
        if (strings != null && !strings.isEmpty()) {
            return strings;
        }
        if (longs != null && !longs.isEmpty()) {
            return longs;
        }
        if (floats != null && !floats.isEmpty()) {
            return floats;
        }
        if (containers != null) {
            return containers;
        }
        if (container != null) {
            return container;
        }
        return null;
    }

    private static @Nullable Serializable whichArgumentValueToUse(@Nullable Integer intValue, @Nullable Long longValue, @Nullable Float floatValue, @Nullable Double doubleValue, @Nullable ArgumentContainerAttachment container, @Nullable ArgumentContainerArrayAttachment containers) {
        if (intValue != null) {
            return intValue;
        }
        if (longValue != null) {
            return longValue;
        }
        if (floatValue != null) {
            return floatValue;
        }
        if (doubleValue != null) {
            return doubleValue;
        }
        if (containers != null) {
            return containers;
        }
        if (container != null) {
            return container;
        }
        return null;
    }

    private FunctionCallArgumentDescriptor(@Nullable Serializable objectValue, @Nullable IByteDataProvider data, @Nullable IArgumentAttachment attachmentValue) {
        this.objectValue = objectValue;
        this.data = data;
        this.attachmentValue = attachmentValue;
    }

    public @Nullable Serializable getReturnObjectValue(@NonNull IFunctionOrAliasSpecExtended functionSpec) {
        assert (this.data == null);
        assert (this.attachmentValue == null);
        ReturnTypeSpec rts = functionSpec.isUnrecognisedFunction() ? null : functionSpec.getReturnType();
        return FunctionCallArgumentDescriptor.convertConstantValue(rts != null ? rts.getUsage() : null, this.objectValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> @Nullable T getObjectValue(@Nullable IConstantOrAliasSpecContainer constantSource, @NonNull Class<T> expectedClazz) {
        Serializable localObjectValue = this.objectValue;
        if (localObjectValue != null && expectedClazz.isAssignableFrom(localObjectValue.getClass())) {
            assert (this.data == null);
            assert (this.attachmentValue == null);
            return (T)localObjectValue;
        }
        if (this.data != null && expectedClazz.isAssignableFrom(this.data.getClass())) {
            assert (localObjectValue == null || localObjectValue instanceof Pointer);
            assert (this.attachmentValue == null);
            return (T)this.data;
        }
        if (this.attachmentValue != null && expectedClazz.isAssignableFrom(this.attachmentValue.getClass())) {
            assert (localObjectValue == null || localObjectValue instanceof Pointer);
            assert (this.data == null);
            return (T)this.attachmentValue;
        }
        if (localObjectValue instanceof Number && expectedClazz.equals(AbstractConstantOrAliasSpecExtended.class)) {
            assert (this.data == null);
            assert (this.attachmentValue == null);
            assert (constantSource != null);
            return (T)constantSource.getConstantSpecByValue(NullUtils.longValueOf((long)((Number)localObjectValue).longValue()));
        }
        if (localObjectValue instanceof Number && Float.class.equals(expectedClazz)) {
            assert (this.data == null);
            assert (this.attachmentValue == null);
            return (T)Float.valueOf(((Number)localObjectValue).floatValue());
        }
        if (localObjectValue instanceof Number && Double.class.equals(expectedClazz)) {
            assert (this.data == null);
            assert (this.attachmentValue == null);
            return (T)Double.valueOf(((Number)localObjectValue).doubleValue());
        }
        if (localObjectValue instanceof Number && Integer.class.equals(expectedClazz)) {
            assert (this.data == null);
            assert (this.attachmentValue == null);
            return (T)Integer.valueOf(((Number)localObjectValue).intValue());
        }
        if (localObjectValue instanceof Number && Long.class.equals(expectedClazz)) {
            assert (this.data == null);
            assert (this.attachmentValue == null);
            return (T)Long.valueOf(((Number)localObjectValue).longValue());
        }
        if (this.attachmentValue != null && expectedClazz.equals(String.class)) {
            assert (localObjectValue == null || localObjectValue instanceof Pointer);
            assert (this.data == null);
            assert (this.attachmentValue instanceof StringsArgAttachment);
            return ((StringsArgAttachment)this.attachmentValue).get(0);
        }
        if (localObjectValue instanceof Long && expectedClazz.equals(Pointer.class)) {
            assert (this.data == null);
            assert (this.attachmentValue == null);
            return (T)Pointer.valueOf((Long)localObjectValue);
        }
        if (AssetReference.class.isAssignableFrom(expectedClazz)) {
            if (this.attachmentValue instanceof ArgumentContainerAttachment) {
                assert (localObjectValue == null || localObjectValue instanceof Pointer);
                assert (this.data == null);
                try {
                    Constructor<T> constructor = expectedClazz.getConstructor(ArgumentContainerAttachment.class);
                    return constructor.newInstance((ArgumentContainerAttachment)this.attachmentValue);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    CoreLogging.severe(null, e, "Failed to created asset data: " + expectedClazz + "(" + localObjectValue + ", " + (localObjectValue != null ? localObjectValue.getClass() : "") + ", " + this.data + ", " + this.attachmentValue + ")");
                }
            } else {
                if (!(localObjectValue instanceof Long)) return null;
                assert (this.data == null);
                assert (this.attachmentValue == null);
                try {
                    Constructor<T> constructor = expectedClazz.getConstructor(Long.class);
                    return constructor.newInstance((Long)localObjectValue);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    CoreLogging.severe(null, e, "Failed to created asset data: " + expectedClazz + "(" + localObjectValue + ", " + localObjectValue.getClass() + ", " + this.data + ", " + this.attachmentValue + ")");
                }
            }
        } else if (localObjectValue instanceof Pointer && this.attachmentValue == null) {
            if (expectedClazz.equals(FloatsArgAttachment.class)) {
                assert (this.data == null);
                return (T)FloatsArgAttachment.create(Collections.EMPTY_LIST);
            }
            if (expectedClazz.equals(LongsArgAttachment.class)) {
                assert (this.data == null);
                return (T)LongsArgAttachment.create(Collections.EMPTY_LIST);
            }
            if (expectedClazz.equals(StringsArgAttachment.class)) {
                assert (this.data == null);
                return (T)StringsArgAttachment.create(Collections.EMPTY_LIST);
            }
            if (expectedClazz.equals(BufferArgAttachment.class)) {
                assert (this.data != null);
                return (T)new BufferArgAttachment(this.data);
            }
            if (expectedClazz.equals(ArgumentContainerAttachment.class)) {
                return (T)new ArgumentContainerAttachment(NullUtils.emptyList());
            }
        }
        assert (false) : "Could not decode object value: " + expectedClazz + "(" + localObjectValue + ", " + (localObjectValue != null ? localObjectValue.getClass() : "") + ", " + this.data + ", " + this.attachmentValue + ")";
        return null;
    }

    public @NonNull Serializable getObjectValue(@NonNull IFunctionOrAliasSpecExtended functionSpec, int argIndex) {
        @Nullable ArgumentSpec as = functionSpec.isUnrecognisedFunction() ? null : functionSpec.getArg().get(argIndex);
        return this.getObjectValue(as);
    }

    public @NonNull Serializable getObjectValue(@Nullable ArgumentSpec as) {
        if (as == null) {
            assert (this.objectValue != null) : "Trying to get the value of an argument where we have no argument spec and no basic value";
            return this.objectValue;
        }
        Serializable mappedVulkanTypeObject = FunctionCallArgumentDescriptor.createHandleType(Handle.HandleType.VULKAN_NON_DISPATCHABLE_HANDLE, this.objectValue, this.attachmentValue, as);
        if (mappedVulkanTypeObject != null) {
            return mappedVulkanTypeObject;
        }
        if (this.objectValue instanceof Pointer) {
            @NonNull Pointer pointerValue = (Pointer)this.objectValue;
            if (this.attachmentValue != null) {
                return FunctionCallArgumentDescriptor.updateArgAttachment(pointerValue, this.attachmentValue);
            }
            if (this.data != null) {
                @NonNull IByteDataProvider localData = this.data;
                if (as.getFormat() != null) {
                    if (as.getFormat().getBuffer() != null) {
                        if (as.getFormat().getBuffer().getTexture() != null) {
                            return FunctionCallArgumentDescriptor.updateArgAttachment(pointerValue, new TextureArgAttachment(localData));
                        }
                        return FunctionCallArgumentDescriptor.updateArgAttachment(pointerValue, new BufferArgAttachment(localData));
                    }
                    if (as.getFormat().getDeferred() != null) {
                        return FunctionCallArgumentDescriptor.updateArgAttachment(pointerValue, new BufferArgAttachment(localData));
                    }
                    if (as.getFormat().getArray() != null && as.getName().equals("configs") && (as.getParentFunctionSpec().equals(KapiSpec.EGL.functions.EGLCHOOSECONFIG) || as.getParentFunctionSpec().equals(KapiSpec.EGL.functions.EGLGETCONFIGS))) {
                        return FunctionCallArgumentDescriptor.updateArgAttachment(pointerValue, new BufferArgAttachment(localData));
                    }
                }
                assert (false) : "Do not know how to make an attachment from argument " + as.getParentFunctionSpec().getName() + "." + as.getName();
                return FunctionCallArgumentDescriptor.updateArgAttachment(pointerValue, new BufferArgAttachment(localData));
            }
            IArgumentAttachment emptyAttachment = FunctionCallArgumentDescriptor.createEmptyArrayArgAttachmentFromSpec(as);
            if (emptyAttachment != null) {
                return FunctionCallArgumentDescriptor.updateArgAttachment(pointerValue, emptyAttachment);
            }
        }
        return (Serializable)NullUtils.neverNull((Object)FunctionCallArgumentDescriptor.convertConstantValue(as.getUsage(), this.objectValue));
    }

    private static @Nullable Serializable createHandleType(@NonNull Handle.HandleType type, @Nullable Serializable objectValue, @Nullable IArgumentAttachment attachmentValue, @NonNull ArgumentSpec argument) {
        if (FunctionCallArgumentDescriptor.isArrayOfHandles(argument) && objectValue instanceof Pointer) {
            LongsArgAttachment longsArgAttachment = FunctionCallArgumentDescriptor.getLongsArgAttachment(attachmentValue);
            Pointer originalPointerValue = (Pointer)objectValue;
            FunctionCallArgumentDescriptor.updateArgAttachment(originalPointerValue, longsArgAttachment);
            return HandleArrayAttachment.create(type, longsArgAttachment);
        }
        if (argument.getBasicType().isHandle() && objectValue instanceof Long) {
            return Handle.valueOf(type, (Long)objectValue);
        }
        if (argument.getBasicType().isPointingToHandle() && objectValue instanceof Pointer) {
            LongPtrArgAttachment longPtrArgAttachment = FunctionCallArgumentDescriptor.getLongPtrArgAttachment(attachmentValue);
            Pointer originalPointerValue = (Pointer)objectValue;
            FunctionCallArgumentDescriptor.updateArgAttachment(originalPointerValue, longPtrArgAttachment);
            return HandleAttachment.create(type, longPtrArgAttachment);
        }
        return null;
    }

    private static @NonNull LongPtrArgAttachment getLongPtrArgAttachment(IArgumentAttachment attachmentValue) {
        LongPtrArgAttachment LongPtrArgAttachment2 = attachmentValue instanceof LongPtrArgAttachment ? (LongPtrArgAttachment)attachmentValue : new LongPtrArgAttachment(0L);
        return LongPtrArgAttachment2;
    }

    private static @NonNull LongsArgAttachment getLongsArgAttachment(IArgumentAttachment attachmentValue) {
        LongsArgAttachment longsArgAttachment = attachmentValue instanceof LongsArgAttachment ? (LongsArgAttachment)attachmentValue : new LongsArgAttachment(NullUtils.emptyList());
        return longsArgAttachment;
    }

    private static boolean isArrayOfHandles(@NonNull ArgumentSpec argument) {
        FormatSpec format = argument.getFormat();
        if (format == null || format.getArray() == null) {
            return false;
        }
        BasicTypeRefSpec basicTypeRef = format.getArray().getBasicTypeRef();
        if (basicTypeRef == null) {
            return false;
        }
        return basicTypeRef.getValue().isHandle();
    }

    private static @Nullable IArgumentAttachment createEmptyArrayArgAttachmentFromSpec(@NonNull ArgumentSpec argumentSpec) {
        FormatSpec formatSpec = argumentSpec.getFormat();
        if (formatSpec == null) {
            return null;
        }
        boolean isOptional = formatSpec.getOptionalAsset() != null;
        ArraySpec arraySpec = formatSpec.getArray();
        ScalarSpec scalarSpec = formatSpec.getScalar();
        if (arraySpec != null) {
            BasicTypeRefSpec arrayBasicType = arraySpec.getBasicTypeRef();
            if (arrayBasicType != null) {
                if (arrayBasicType.getValue().getJtype() == ElementTypeSpec.FLOAT) {
                    return new FloatsArgAttachment(NullUtils.emptyList());
                }
                if (arrayBasicType.getValue().getJtype() == ElementTypeSpec.POINTER || arrayBasicType.getValue().getJtype() == ElementTypeSpec.INTEGER || arrayBasicType.getValue().getJtype() == ElementTypeSpec.LONG) {
                    return new LongsArgAttachment(NullUtils.emptyList());
                }
                if (arrayBasicType.getValue().getContainer() != null) {
                    return new ArgumentContainerArrayAttachment(NullUtils.emptyList());
                }
                assert (false) : "Unsupported array basic type: " + arrayBasicType.getValue().getId();
            } else if (arraySpec.getString() != null) {
                return new StringsArgAttachment(NullUtils.emptyList());
            }
            assert (false) : "Unsupported array spec: " + arraySpec;
        } else if (scalarSpec != null) {
            if (scalarSpec.getString() != null) {
                if (isOptional) {
                    return new StringsArgAttachment(NullUtils.emptyList());
                }
                return new StringsArgAttachment("");
            }
            if (scalarSpec.getBasicTypeRef() != null) {
                if (scalarSpec.getBasicTypeRef().getValue().getContainer() != null) {
                    return new ArgumentContainerAttachment(NullUtils.EMPTY_LIST);
                }
                if (scalarSpec.getBasicTypeRef().getValue().getJtype() == ElementTypeSpec.POINTER || scalarSpec.getBasicTypeRef().getValue().getJtype() == ElementTypeSpec.INTEGER || scalarSpec.getBasicTypeRef().getValue().getJtype() == ElementTypeSpec.LONG) {
                    return new LongPtrArgAttachment(0L);
                }
                assert (false) : "Unsupported scalar spec basic type: " + scalarSpec.getBasicTypeRef().getValue().getId();
            }
            assert (false) : "Unsupported scalar spec: " + scalarSpec;
        } else if (formatSpec.getBuffer() != null) {
            if (formatSpec.getBuffer().getTexture() != null) {
                return new TextureArgAttachment(isOptional ? null : IByteDataProvider.EMPTY);
            }
            return new BufferArgAttachment(isOptional ? null : IByteDataProvider.EMPTY);
        }
        return null;
    }

    public IArgumentAttachment getRawAttachmentValue() {
        return this.attachmentValue;
    }

    public @Nullable IByteDataProvider getData() {
        return this.data;
    }

    public Serializable getRawObjectValue() {
        return this.objectValue;
    }

    public @Nullable ArgumentContainerArrayAttachment getContainers() {
        if (this.attachmentValue instanceof ArgumentContainerArrayAttachment) {
            return (ArgumentContainerArrayAttachment)this.attachmentValue;
        }
        if (this.objectValue instanceof ArgumentContainerArrayAttachment) {
            return (ArgumentContainerArrayAttachment)this.objectValue;
        }
        return null;
    }

    public @Nullable ArgumentContainerAttachment getContainer() {
        if (this.attachmentValue instanceof ArgumentContainerAttachment) {
            return (ArgumentContainerAttachment)this.attachmentValue;
        }
        if (this.objectValue instanceof ArgumentContainerAttachment) {
            return (ArgumentContainerAttachment)this.objectValue;
        }
        return null;
    }

    public String toString() {
        if (this.attachmentValue != null) {
            return "" + this.attachmentValue;
        }
        if (this.data != null) {
            return "" + this.data;
        }
        return "" + this.objectValue;
    }

    public @Nullable BufferArgAttachment getClImageData() {
        if (this.data != null) {
            return new BufferArgAttachment(this.data);
        }
        return null;
    }
}

