/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.marshaller.stream;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.utils.config.ProcessEnvironment;
import com.google.protobuf.MessageLite;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProtocolBufferLogger {
    private static final @NonNull String PROTOBUF_ENV_VAR = "DEBUG_PROTOBUF_FILE";
    private static @Nullable OutputStream logStream = null;
    private static boolean logStreamIsConfigured = false;
    private static final byte @NonNull [] PROTOBUF_START_READ_TRACE = ProtocolBufferLogger.getUTF8Bytes("PROTOBUF-READ>>>");
    private static final byte @NonNull [] PROTOBUF_END_READ_TRACE = ProtocolBufferLogger.getUTF8Bytes("<<<PROTOBUF-READ");
    private static final byte @NonNull [] PROTOBUF_START_WRITE_TRACE = ProtocolBufferLogger.getUTF8Bytes("PROTOBUF-WRITE>>>");
    private static final byte @NonNull [] PROTOBUF_END_WRITE_TRACE = ProtocolBufferLogger.getUTF8Bytes("<<<PROTOBUF-WRITE");

    private static byte @NonNull [] getUTF8Bytes(@NonNull String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    private static synchronized @Nullable OutputStream getLogStream() {
        if (logStreamIsConfigured) {
            return logStream;
        }
        assert (logStream == null) : "Internal state error: protobuf stream is unconfigured, yet is non-null";
        @Nullable String logFileName = ProcessEnvironment.ENV.asString(PROTOBUF_ENV_VAR);
        if (logFileName != null) {
            try {
                logStream = new FileOutputStream(new File(logFileName));
            }
            catch (FileNotFoundException e) {
                CoreLogging.warning(null, "Environment variable DEBUG_PROTOBUF_FILE contains log file name \"" + logFileName + "\". That file can't be written.");
            }
        }
        logStreamIsConfigured = true;
        return logStream;
    }

    static synchronized void setLogStream(@Nullable OutputStream newStream) {
        logStream = newStream;
        logStreamIsConfigured = true;
    }

    private static void log(byte @NonNull [] prefix, @NonNull MessageLite message, byte @NonNull [] suffix) throws IOException {
        @Nullable OutputStream stream = ProtocolBufferLogger.getLogStream();
        if (stream == null) {
            return;
        }
        stream.write(prefix);
        message.writeTo(stream);
        stream.write(suffix);
        stream.flush();
    }

    public static void logWrite(@NonNull MessageLite message) throws IOException {
        ProtocolBufferLogger.log(PROTOBUF_START_WRITE_TRACE, message, PROTOBUF_END_WRITE_TRACE);
    }

    public static void logRead(@NonNull MessageLite message) throws IOException {
        ProtocolBufferLogger.log(PROTOBUF_START_READ_TRACE, message, PROTOBUF_END_READ_TRACE);
    }
}

